/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.google.common.base.Objects;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class ContainerState {
    @JsonProperty(value="Running")
    private Boolean running;
    @JsonProperty(value="Paused")
    private Boolean paused;
    @JsonProperty(value="Restarting")
    private Boolean restarting;
    @JsonProperty(value="Pid")
    private Integer pid;
    @JsonProperty(value="ExitCode")
    private Integer exitCode;
    @JsonProperty(value="StartedAt")
    private Date startedAt;
    @JsonProperty(value="FinishedAt")
    private Date finishedAt;
    @JsonProperty(value="Error")
    private String error;
    @JsonProperty(value="OOMKilled")
    private Boolean oomKilled;

    public Boolean running() {
        return this.running;
    }

    public Boolean paused() {
        return this.paused;
    }

    public Boolean restarting() {
        return this.restarting;
    }

    public Integer pid() {
        return this.pid;
    }

    public Integer exitCode() {
        return this.exitCode;
    }

    public Date startedAt() {
        return this.startedAt == null ? null : new Date(this.startedAt.getTime());
    }

    public Date finishedAt() {
        return this.finishedAt == null ? null : new Date(this.finishedAt.getTime());
    }

    public String error() {
        return this.error;
    }

    public Boolean oomKilled() {
        return this.oomKilled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerState that = (ContainerState)o;
        if (this.exitCode != null ? !this.exitCode.equals(that.exitCode) : that.exitCode != null) {
            return false;
        }
        if (this.finishedAt != null ? !this.finishedAt.equals(that.finishedAt) : that.finishedAt != null) {
            return false;
        }
        if (this.pid != null ? !this.pid.equals(that.pid) : that.pid != null) {
            return false;
        }
        if (this.running != null ? !this.running.equals(that.running) : that.running != null) {
            return false;
        }
        if (this.paused != null ? !this.paused.equals(that.paused) : that.paused != null) {
            return false;
        }
        if (this.restarting != null ? !this.restarting.equals(that.restarting) : that.restarting != null) {
            return false;
        }
        if (this.startedAt != null ? !this.startedAt.equals(that.startedAt) : that.startedAt != null) {
            return false;
        }
        if (this.error != null ? !this.error.equals(that.error) : that.error != null) {
            return false;
        }
        return !(this.oomKilled != null ? !this.oomKilled.equals(that.oomKilled) : that.oomKilled != null);
    }

    public int hashCode() {
        int result = this.running != null ? this.running.hashCode() : 0;
        result = 31 * result + (this.pid != null ? this.pid.hashCode() : 0);
        result = 31 * result + (this.paused != null ? this.paused.hashCode() : 0);
        result = 31 * result + (this.restarting != null ? this.restarting.hashCode() : 0);
        result = 31 * result + (this.exitCode != null ? this.exitCode.hashCode() : 0);
        result = 31 * result + (this.startedAt != null ? this.startedAt.hashCode() : 0);
        result = 31 * result + (this.finishedAt != null ? this.finishedAt.hashCode() : 0);
        result = 31 * result + (this.error != null ? this.error.hashCode() : 0);
        result = 31 * result + (this.oomKilled != null ? this.oomKilled.hashCode() : 0);
        return result;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("running", (Object)this.running).add("pid", (Object)this.pid).add("paused", (Object)this.paused).add("restarting", (Object)this.restarting).add("exitCode", (Object)this.exitCode).add("startedAt", (Object)this.startedAt).add("finishedAt", (Object)this.finishedAt).add("error", (Object)this.error).add("oomKilled", (Object)this.oomKilled).toString();
    }
}

