/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.node;

import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.Base64Variant;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.Base64Variants;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonGenerator;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonLocation;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonParseException;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonToken;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.io.CharTypes;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.io.NumberInput;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.node.JsonNodeType;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.node.ValueNode;
import java.io.IOException;

public final class TextNode
extends ValueNode {
    static final int INT_SPACE = 32;
    static final TextNode EMPTY_STRING_NODE = new TextNode("");
    final String _value;

    public TextNode(String string) {
        this._value = string;
    }

    public static TextNode valueOf(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return EMPTY_STRING_NODE;
        }
        return new TextNode(string);
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.STRING;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.VALUE_STRING;
    }

    @Override
    public String textValue() {
        return this._value;
    }

    public byte[] getBinaryValue(Base64Variant base64Variant) throws IOException {
        ByteArrayBuilder byteArrayBuilder = new ByteArrayBuilder(100);
        String string = this._value;
        int n = 0;
        int n2 = string.length();
        block0: while (n < n2) {
            char c;
            do {
                c = string.charAt(n++);
                if (n >= n2) break block0;
            } while (c <= ' ');
            int n3 = base64Variant.decodeBase64Char(c);
            if (n3 < 0) {
                this._reportInvalidBase64(base64Variant, c, 0);
            }
            int n4 = n3;
            if (n >= n2) {
                this._reportBase64EOF();
            }
            if ((n3 = base64Variant.decodeBase64Char(c = string.charAt(n++))) < 0) {
                this._reportInvalidBase64(base64Variant, c, 1);
            }
            n4 = n4 << 6 | n3;
            if (n >= n2) {
                if (!base64Variant.usesPadding()) {
                    byteArrayBuilder.append(n4 >>= 4);
                    break;
                }
                this._reportBase64EOF();
            }
            if ((n3 = base64Variant.decodeBase64Char(c = string.charAt(n++))) < 0) {
                if (n3 != -2) {
                    this._reportInvalidBase64(base64Variant, c, 2);
                }
                if (n >= n2) {
                    this._reportBase64EOF();
                }
                if (!base64Variant.usesPaddingChar(c = string.charAt(n++))) {
                    this._reportInvalidBase64(base64Variant, c, 3, "expected padding character '" + base64Variant.getPaddingChar() + "'");
                }
                byteArrayBuilder.append(n4 >>= 4);
                continue;
            }
            n4 = n4 << 6 | n3;
            if (n >= n2) {
                if (!base64Variant.usesPadding()) {
                    byteArrayBuilder.appendTwoBytes(n4 >>= 2);
                    break;
                }
                this._reportBase64EOF();
            }
            if ((n3 = base64Variant.decodeBase64Char(c = string.charAt(n++))) < 0) {
                if (n3 != -2) {
                    this._reportInvalidBase64(base64Variant, c, 3);
                }
                byteArrayBuilder.appendTwoBytes(n4 >>= 2);
                continue;
            }
            n4 = n4 << 6 | n3;
            byteArrayBuilder.appendThreeBytes(n4);
        }
        return byteArrayBuilder.toByteArray();
    }

    @Override
    public byte[] binaryValue() throws IOException {
        return this.getBinaryValue(Base64Variants.getDefaultVariant());
    }

    @Override
    public String asText() {
        return this._value;
    }

    @Override
    public boolean asBoolean(boolean bl) {
        if (this._value != null && "true".equals(this._value.trim())) {
            return true;
        }
        return bl;
    }

    @Override
    public int asInt(int n) {
        return NumberInput.parseAsInt(this._value, n);
    }

    @Override
    public long asLong(long l) {
        return NumberInput.parseAsLong(this._value, l);
    }

    @Override
    public double asDouble(double d) {
        return NumberInput.parseAsDouble(this._value, d);
    }

    @Override
    public final void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        if (this._value == null) {
            jsonGenerator.writeNull();
        } else {
            jsonGenerator.writeString(this._value);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        return ((TextNode)object)._value.equals(this._value);
    }

    public int hashCode() {
        return this._value.hashCode();
    }

    @Override
    public String toString() {
        int n = this._value.length();
        n = n + 2 + (n >> 4);
        StringBuilder stringBuilder = new StringBuilder(n);
        TextNode.appendQuoted(stringBuilder, this._value);
        return stringBuilder.toString();
    }

    protected static void appendQuoted(StringBuilder stringBuilder, String string) {
        stringBuilder.append('\"');
        CharTypes.appendQuoted(stringBuilder, string);
        stringBuilder.append('\"');
    }

    protected void _reportInvalidBase64(Base64Variant base64Variant, char c, int n) throws JsonParseException {
        this._reportInvalidBase64(base64Variant, c, n, null);
    }

    protected void _reportInvalidBase64(Base64Variant base64Variant, char c, int n, String string) throws JsonParseException {
        String string2 = c <= ' ' ? "Illegal white space character (code 0x" + Integer.toHexString(c) + ") as character #" + (n + 1) + " of 4-char base64 unit: can only used between units" : (base64Variant.usesPaddingChar(c) ? "Unexpected padding character ('" + base64Variant.getPaddingChar() + "') as character #" + (n + 1) + " of 4-char base64 unit: padding only legal as 3rd or 4th character" : (!Character.isDefined(c) || Character.isISOControl(c) ? "Illegal character (code 0x" + Integer.toHexString(c) + ") in base64 content" : "Illegal character '" + c + "' (code 0x" + Integer.toHexString(c) + ") in base64 content"));
        if (string != null) {
            string2 = string2 + ": " + string;
        }
        throw new JsonParseException(string2, JsonLocation.NA);
    }

    protected void _reportBase64EOF() throws JsonParseException {
        throw new JsonParseException("Unexpected end-of-String when base64 content", JsonLocation.NA);
    }
}

