/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import com.spotify.docker.client.shaded.javax.ws.rs.Consumes;
import com.spotify.docker.client.shaded.javax.ws.rs.Produces;
import com.spotify.docker.client.shaded.javax.ws.rs.core.MediaType;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.jersey.message.internal.AcceptableMediaType;
import org.glassfish.jersey.message.internal.HttpHeaderReader;
import org.glassfish.jersey.message.internal.QualitySourceMediaType;

public class MediaTypes {
    public static final MediaType WADL = MediaType.valueOf("application/vnd.sun.wadl+xml");
    public static final MediaType FAST_INFOSET = MediaType.valueOf("application/fastinfoset");
    public static final Comparator<List<? extends MediaType>> MEDIA_TYPE_LIST_COMPARATOR = new Comparator<List<? extends MediaType>>(){

        @Override
        public int compare(List<? extends MediaType> o1, List<? extends MediaType> o2) {
            return MEDIA_TYPE_COMPARATOR.compare(this.getLeastSpecific(o1), this.getLeastSpecific(o2));
        }

        public MediaType getLeastSpecific(List<? extends MediaType> l) {
            return l.get(l.size() - 1);
        }
    };
    public static final MediaType GENERAL_MEDIA_TYPE = new MediaType("*", "*");
    public static final List<MediaType> GENERAL_MEDIA_TYPE_LIST = MediaTypes.createMediaTypeList();
    static final AcceptableMediaType GENERAL_ACCEPT_MEDIA_TYPE = new AcceptableMediaType("*", "*");
    static final List<AcceptableMediaType> GENERAL_ACCEPT_MEDIA_TYPE_LIST = MediaTypes.createAcceptMediaTypeList();
    public static final List<MediaType> GENERAL_QUALITY_SOURCE_MEDIA_TYPE_LIST = MediaTypes.createQualitySourceMediaTypeList();
    public static final Comparator<QualitySourceMediaType> QUALITY_SOURCE_MEDIA_TYPE_COMPARATOR = new Comparator<QualitySourceMediaType>(){

        @Override
        public int compare(QualitySourceMediaType o1, QualitySourceMediaType o2) {
            int i = o2.getQualitySource() - o1.getQualitySource();
            if (i != 0) {
                return i;
            }
            return MEDIA_TYPE_COMPARATOR.compare(o1, o2);
        }
    };
    public static final Comparator<MediaType> MEDIA_TYPE_COMPARATOR = new Comparator<MediaType>(){

        @Override
        public int compare(MediaType o1, MediaType o2) {
            if (o1.isWildcardType() && !o2.isWildcardType()) {
                return 1;
            }
            if (o2.isWildcardType() && !o1.isWildcardType()) {
                return -1;
            }
            if (o1.isWildcardSubtype() && !o2.isWildcardSubtype()) {
                return 1;
            }
            if (o2.isWildcardSubtype() && !o1.isWildcardSubtype()) {
                return -1;
            }
            return 0;
        }
    };
    private static Map<String, MediaType> wildcardSubtypeCache = new HashMap<String, MediaType>(){
        private static final long serialVersionUID = 3109256773218160485L;
        {
            this.put("application", new MediaType("application", "*"));
            this.put("multipart", new MediaType("multipart", "*"));
            this.put("text", new MediaType("text", "*"));
        }
    };

    private MediaTypes() {
    }

    public static boolean typeEqual(MediaType m1, MediaType m2) {
        if (m1 == null || m2 == null) {
            return false;
        }
        return m1.getSubtype().equalsIgnoreCase(m2.getSubtype()) && m1.getType().equalsIgnoreCase(m2.getType());
    }

    public static boolean intersect(List<? extends MediaType> ml1, List<? extends MediaType> ml2) {
        for (MediaType mediaType : ml1) {
            for (MediaType mediaType2 : ml2) {
                if (!MediaTypes.typeEqual(mediaType, mediaType2)) continue;
                return true;
            }
        }
        return false;
    }

    public static MediaType mostSpecific(MediaType m1, MediaType m2) {
        if (m1.isWildcardSubtype() && !m2.isWildcardSubtype()) {
            return m2;
        }
        if (m1.isWildcardType() && !m2.isWildcardType()) {
            return m2;
        }
        return m1;
    }

    private static List<MediaType> createMediaTypeList() {
        return Collections.singletonList(GENERAL_MEDIA_TYPE);
    }

    private static List<AcceptableMediaType> createAcceptMediaTypeList() {
        return Collections.singletonList(GENERAL_ACCEPT_MEDIA_TYPE);
    }

    public static List<MediaType> createFrom(Consumes annotation) {
        if (annotation == null) {
            return GENERAL_MEDIA_TYPE_LIST;
        }
        return MediaTypes.createFrom(annotation.value());
    }

    public static List<MediaType> createFrom(Produces annotation) {
        if (annotation == null) {
            return GENERAL_MEDIA_TYPE_LIST;
        }
        return MediaTypes.createFrom(annotation.value());
    }

    public static List<MediaType> createFrom(String[] mediaTypes) {
        ArrayList<MediaType> l = new ArrayList<MediaType>();
        try {
            for (String mediaType : mediaTypes) {
                HttpHeaderReader.readMediaTypes(l, mediaType);
            }
            Collections.sort(l, MEDIA_TYPE_COMPARATOR);
            return l;
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private static List<MediaType> createQualitySourceMediaTypeList() {
        return Collections.singletonList(new QualitySourceMediaType("*", "*"));
    }

    public static List<MediaType> createQualitySourceMediaTypes(Produces mime) {
        if (mime == null || mime.value().length == 0) {
            return GENERAL_QUALITY_SOURCE_MEDIA_TYPE_LIST;
        }
        return new ArrayList<MediaType>(MediaTypes.createQualitySourceMediaTypes(mime.value()));
    }

    public static List<QualitySourceMediaType> createQualitySourceMediaTypes(String[] mediaTypes) {
        try {
            return HttpHeaderReader.readQualitySourceMediaType(mediaTypes);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static int getQuality(MediaType mt) {
        String qParam = mt.getParameters().get("q");
        return MediaTypes.readQualityFactor(qParam);
    }

    private static int readQualityFactor(String qParam) throws IllegalArgumentException {
        if (qParam == null) {
            return 1000;
        }
        try {
            return HttpHeaderReader.readQualityFactor(qParam);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static MediaType stripQualityParams(MediaType mediaType) {
        Map<String, String> oldParameters = mediaType.getParameters();
        if (oldParameters.isEmpty()) {
            return mediaType;
        }
        HashMap<String, String> newParameters = new HashMap<String, String>();
        for (Map.Entry<String, String> e : oldParameters.entrySet()) {
            boolean isQs = e.getKey().equals("qs");
            boolean isQ = e.getKey().equals("q");
            if (isQ || isQs) continue;
            newParameters.put(e.getKey(), e.getValue());
        }
        return new MediaType(mediaType.getType(), mediaType.getSubtype(), newParameters);
    }

    public static MediaType getTypeWildCart(MediaType mediaType) {
        MediaType mt = wildcardSubtypeCache.get(mediaType.getType());
        if (mt == null) {
            mt = new MediaType(mediaType.getType(), "*");
        }
        return mt;
    }

    public static String convertToString(Iterable<MediaType> mediaTypes) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (MediaType mediaType : mediaTypes) {
            if (!isFirst) {
                sb.append(", ");
            } else {
                isFirst = false;
            }
            sb.append("\"").append(mediaType.toString()).append("\"");
        }
        return sb.toString();
    }
}

