/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.google.common.base.Objects;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class ImageInfo {
    @JsonProperty(value="Id")
    private String id;
    @JsonProperty(value="Parent")
    private String parent;
    @JsonProperty(value="Comment")
    private String comment;
    @JsonProperty(value="Created")
    private Date created;
    @JsonProperty(value="Container")
    private String container;
    @JsonProperty(value="ContainerConfig")
    private ContainerConfig containerConfig;
    @JsonProperty(value="DockerVersion")
    private String dockerVersion;
    @JsonProperty(value="Author")
    private String author;
    @JsonProperty(value="Config")
    private ContainerConfig config;
    @JsonProperty(value="Architecture")
    private String architecture;
    @JsonProperty(value="Os")
    private String os;
    @JsonProperty(value="Size")
    private Long size;
    @JsonProperty(value="VirtualSize")
    private Long virtualSize;

    public String id() {
        return this.id;
    }

    public String parent() {
        return this.parent;
    }

    public String comment() {
        return this.comment;
    }

    public Date created() {
        return this.created == null ? null : new Date(this.created.getTime());
    }

    public String container() {
        return this.container;
    }

    public ContainerConfig containerConfig() {
        return this.containerConfig;
    }

    public String dockerVersion() {
        return this.dockerVersion;
    }

    public String author() {
        return this.author;
    }

    public ContainerConfig config() {
        return this.config;
    }

    public String architecture() {
        return this.architecture;
    }

    public String os() {
        return this.os;
    }

    public Long size() {
        return this.size;
    }

    public Long virtualSize() {
        return this.virtualSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageInfo imageInfo = (ImageInfo)o;
        if (this.architecture != null ? !this.architecture.equals(imageInfo.architecture) : imageInfo.architecture != null) {
            return false;
        }
        if (this.author != null ? !this.author.equals(imageInfo.author) : imageInfo.author != null) {
            return false;
        }
        if (this.comment != null ? !this.comment.equals(imageInfo.comment) : imageInfo.comment != null) {
            return false;
        }
        if (this.config != null ? !this.config.equals(imageInfo.config) : imageInfo.config != null) {
            return false;
        }
        if (this.container != null ? !this.container.equals(imageInfo.container) : imageInfo.container != null) {
            return false;
        }
        if (this.containerConfig != null ? !this.containerConfig.equals(imageInfo.containerConfig) : imageInfo.containerConfig != null) {
            return false;
        }
        if (this.created != null ? !this.created.equals(imageInfo.created) : imageInfo.created != null) {
            return false;
        }
        if (this.dockerVersion != null ? !this.dockerVersion.equals(imageInfo.dockerVersion) : imageInfo.dockerVersion != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(imageInfo.id) : imageInfo.id != null) {
            return false;
        }
        if (this.os != null ? !this.os.equals(imageInfo.os) : imageInfo.os != null) {
            return false;
        }
        if (this.parent != null ? !this.parent.equals(imageInfo.parent) : imageInfo.parent != null) {
            return false;
        }
        if (this.size != null ? !this.size.equals(imageInfo.size) : imageInfo.size != null) {
            return false;
        }
        return !(this.virtualSize != null ? !this.virtualSize.equals(imageInfo.virtualSize) : imageInfo.virtualSize != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.parent != null ? this.parent.hashCode() : 0);
        result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
        result = 31 * result + (this.created != null ? this.created.hashCode() : 0);
        result = 31 * result + (this.container != null ? this.container.hashCode() : 0);
        result = 31 * result + (this.containerConfig != null ? this.containerConfig.hashCode() : 0);
        result = 31 * result + (this.dockerVersion != null ? this.dockerVersion.hashCode() : 0);
        result = 31 * result + (this.author != null ? this.author.hashCode() : 0);
        result = 31 * result + (this.config != null ? this.config.hashCode() : 0);
        result = 31 * result + (this.architecture != null ? this.architecture.hashCode() : 0);
        result = 31 * result + (this.os != null ? this.os.hashCode() : 0);
        result = 31 * result + (this.size != null ? this.size.hashCode() : 0);
        result = 31 * result + (this.virtualSize != null ? this.virtualSize.hashCode() : 0);
        return result;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("parent", (Object)this.parent).add("comment", (Object)this.comment).add("created", (Object)this.created).add("container", (Object)this.container).add("containerConfig", (Object)this.containerConfig).add("dockerVersion", (Object)this.dockerVersion).add("author", (Object)this.author).add("config", (Object)this.config).add("architecture", (Object)this.architecture).add("os", (Object)this.os).add("size", (Object)this.size).add("virtualSize", (Object)this.virtualSize).toString();
    }
}

