/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class Container {
    @JsonProperty(value="Id")
    private String id;
    @JsonProperty(value="Names")
    private ImmutableList<String> names;
    @JsonProperty(value="Image")
    private String image;
    @JsonProperty(value="Command")
    private String command;
    @JsonProperty(value="Created")
    private Long created;
    @JsonProperty(value="Status")
    private String status;
    @JsonProperty(value="Ports")
    private ImmutableList<PortMapping> ports;
    @JsonProperty(value="SizeRw")
    private Long sizeRw;
    @JsonProperty(value="SizeRootFs")
    private Long sizeRootFs;

    public String portsAsString() {
        StringBuilder sb = new StringBuilder();
        if (this.ports != null) {
            for (PortMapping port : this.ports) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                if (port.ip != null) {
                    sb.append(port.ip).append(":");
                }
                if (port.publicPort > 0) {
                    sb.append(port.privatePort).append("->").append(port.publicPort);
                } else {
                    sb.append(port.privatePort);
                }
                sb.append("/").append(port.type);
            }
        }
        return sb.toString();
    }

    public String id() {
        return this.id;
    }

    public List<String> names() {
        return this.names;
    }

    public String image() {
        return this.image;
    }

    public String command() {
        return this.command;
    }

    public Long created() {
        return this.created;
    }

    public String status() {
        return this.status;
    }

    public List<PortMapping> ports() {
        return this.ports;
    }

    public Long sizeRw() {
        return this.sizeRw;
    }

    public Long sizeRootFs() {
        return this.sizeRootFs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Container container = (Container)o;
        if (this.command != null ? !this.command.equals(container.command) : container.command != null) {
            return false;
        }
        if (this.created != null ? !this.created.equals(container.created) : container.created != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(container.id) : container.id != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(container.image) : container.image != null) {
            return false;
        }
        if (this.names != null ? !this.names.equals(container.names) : container.names != null) {
            return false;
        }
        if (this.ports != null ? !this.ports.equals(container.ports) : container.ports != null) {
            return false;
        }
        if (this.sizeRootFs != null ? !this.sizeRootFs.equals(container.sizeRootFs) : container.sizeRootFs != null) {
            return false;
        }
        if (this.sizeRw != null ? !this.sizeRw.equals(container.sizeRw) : container.sizeRw != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(container.status) : container.status != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.names != null ? this.names.hashCode() : 0);
        result = 31 * result + (this.image != null ? this.image.hashCode() : 0);
        result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
        result = 31 * result + (this.created != null ? this.created.hashCode() : 0);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.ports != null ? this.ports.hashCode() : 0);
        result = 31 * result + (this.sizeRw != null ? this.sizeRw.hashCode() : 0);
        result = 31 * result + (this.sizeRootFs != null ? this.sizeRootFs.hashCode() : 0);
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("image", (Object)this.image).add("command", (Object)this.command).add("created", (Object)this.created).add("status", (Object)this.status).add("ports", this.ports).add("sizeRw", (Object)this.sizeRw).add("sizeRootFs", (Object)this.sizeRootFs).toString();
    }

    public static class PortMapping {
        @JsonProperty(value="PrivatePort")
        private int privatePort;
        @JsonProperty(value="PublicPort")
        private int publicPort;
        @JsonProperty(value="Type")
        private String type;
        @JsonProperty(value="IP")
        private String ip;

        public String getIp() {
            return this.ip;
        }

        public int getPrivatePort() {
            return this.privatePort;
        }

        public int getPublicPort() {
            return this.publicPort;
        }

        public String getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PortMapping that = (PortMapping)o;
            if (this.privatePort != that.privatePort) {
                return false;
            }
            if (this.publicPort != that.publicPort) {
                return false;
            }
            if (this.ip != null ? !this.ip.equals(that.ip) : that.ip != null) {
                return false;
            }
            return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
        }

        public int hashCode() {
            int result = this.privatePort;
            result = 31 * result + this.publicPort;
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            result = 31 * result + (this.ip != null ? this.ip.hashCode() : 0);
            return result;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("privatePort", this.privatePort).add("publicPort", this.publicPort).add("type", (Object)this.type).add("ip", (Object)this.ip).toString();
        }
    }
}

