/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class LogConfig {
    @JsonProperty(value="Type")
    private String logType;
    @JsonProperty(value="Config")
    private Map<String, String> logOptions;

    private LogConfig() {
    }

    private LogConfig(String logType, Map<String, String> logOptions) {
        this.logType = logType;
        this.logOptions = ImmutableMap.copyOf(logOptions);
    }

    public String logType() {
        return this.logType;
    }

    public Map<String, String> logOptions() {
        return this.logOptions == null ? null : Collections.unmodifiableMap(this.logOptions);
    }

    public static LogConfig create(String logType) {
        return LogConfig.create(logType, Collections.emptyMap());
    }

    public static LogConfig create(String logType, Map<String, String> logOptions) {
        return new LogConfig(logType, logOptions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogConfig that = (LogConfig)o;
        if (this.logType != null ? !this.logType.equals(that.logType) : that.logType != null) {
            return false;
        }
        return !(this.logOptions != null ? !this.logOptions.equals(that.logOptions) : that.logOptions != null);
    }

    public int hashCode() {
        int result = this.logType != null ? this.logType.hashCode() : 0;
        result = 31 * result + (this.logOptions != null ? this.logOptions.hashCode() : 0);
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Type", (Object)this.logType).add("Config", this.logOptions).toString();
    }
}

