/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.MappingIterator;
import com.google.common.io.ByteStreams;
import com.spotify.docker.client.DockerException;
import com.spotify.docker.client.DockerTimeoutException;
import com.spotify.docker.client.ObjectMapperProvider;
import com.spotify.docker.client.ProgressHandler;
import com.spotify.docker.client.messages.ProgressMessage;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProgressStream
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(ProgressStream.class);
    private final InputStream stream;
    private final MappingIterator<ProgressMessage> iterator;
    private volatile boolean closed;

    ProgressStream(InputStream stream) throws IOException {
        this.stream = stream;
        JsonParser parser = ObjectMapperProvider.objectMapper().getFactory().createParser(stream);
        this.iterator = ObjectMapperProvider.objectMapper().readValues(parser, ProgressMessage.class);
    }

    public boolean hasNextMessage(String method, URI uri) throws DockerException {
        try {
            return this.iterator.hasNextValue();
        }
        catch (SocketTimeoutException e) {
            throw new DockerTimeoutException(method, uri, e);
        }
        catch (IOException e) {
            throw new DockerException(e);
        }
    }

    public ProgressMessage nextMessage(String method, URI uri) throws DockerException {
        try {
            return (ProgressMessage)this.iterator.nextValue();
        }
        catch (SocketTimeoutException e) {
            throw new DockerTimeoutException(method, uri, e);
        }
        catch (IOException e) {
            throw new DockerException(e);
        }
    }

    public void tail(ProgressHandler handler, String method, URI uri) throws DockerException {
        while (this.hasNextMessage(method, uri)) {
            handler.progress(this.nextMessage(method, uri));
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.closed) {
            log.warn(this + " not closed properly");
            this.close();
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        ByteStreams.copy((InputStream)this.stream, (OutputStream)ByteStreams.nullOutputStream());
    }
}

