/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.google.common.base.MoreObjects;
import com.spotify.docker.client.messages.Ipam;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class NetworkConfig {
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="Driver")
    private String driver;
    @JsonProperty(value="IPAM")
    private Ipam ipam;
    @JsonProperty(value="Options")
    private Map<String, String> options;
    @JsonProperty(value="CheckDuplicate")
    private boolean checkDuplicate;

    private NetworkConfig(Builder builder) {
        this.name = builder.name;
        this.options = builder.options;
        this.driver = builder.driver;
        this.ipam = builder.ipam;
        this.checkDuplicate = builder.checkDuplicate;
    }

    public String name() {
        return this.name;
    }

    public String driver() {
        return this.driver;
    }

    public Ipam ipam() {
        return this.ipam;
    }

    public Map<String, String> options() {
        return this.options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkConfig that = (NetworkConfig)o;
        if (this.checkDuplicate != that.checkDuplicate) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.driver != null ? !this.driver.equals(that.driver) : that.driver != null) {
            return false;
        }
        if (this.ipam != null ? !this.ipam.equals(that.ipam) : that.ipam != null) {
            return false;
        }
        return !(this.options == null ? that.options != null : !this.options.equals(that.options));
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.driver != null ? this.driver.hashCode() : 0);
        result = 31 * result + (this.ipam != null ? this.ipam.hashCode() : 0);
        result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
        result = 31 * result + (this.checkDuplicate ? 1 : 0);
        return result;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("driver", (Object)this.driver).add("options", this.options).add("checkDuplicate", this.checkDuplicate).add("ipam", (Object)this.ipam).toString();
    }

    public static class Builder {
        private String name;
        private Map<String, String> options = new HashMap<String, String>();
        private String driver;
        private Ipam ipam;
        public boolean checkDuplicate;

        private Builder() {
        }

        public Builder name(String name) {
            if (name != null && !name.isEmpty()) {
                this.name = name;
            }
            return this;
        }

        public Builder option(String key, String value) {
            if (key != null && !key.isEmpty()) {
                this.options.put(key, value);
            }
            return this;
        }

        public Builder ipam(Ipam ipam) {
            if (ipam != null) {
                this.ipam = ipam;
            }
            return this;
        }

        public Builder driver(String driver) {
            if (driver != null && !driver.isEmpty()) {
                this.driver = driver;
            }
            return this;
        }

        public Builder checkDuplicate(boolean check) {
            this.checkDuplicate = check;
            return this;
        }

        public NetworkConfig build() {
            return new NetworkConfig(this);
        }
    }
}

