/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerMount;
import com.spotify.docker.client.messages.ContainerState;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.NetworkSettings;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE)
public class ContainerInfo {
    @JsonProperty(value="Id")
    private String id;
    @JsonProperty(value="Created")
    private Date created;
    @JsonProperty(value="Path")
    private String path;
    @JsonProperty(value="Args")
    private ImmutableList<String> args;
    @JsonProperty(value="Config")
    private ContainerConfig config;
    @JsonProperty(value="HostConfig")
    private HostConfig hostConfig;
    @JsonProperty(value="State")
    private ContainerState state;
    @JsonProperty(value="Image")
    private String image;
    @JsonProperty(value="NetworkSettings")
    private NetworkSettings networkSettings;
    @JsonProperty(value="ResolvConfPath")
    private String resolvConfPath;
    @JsonProperty(value="HostnamePath")
    private String hostnamePath;
    @JsonProperty(value="HostsPath")
    private String hostsPath;
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="Driver")
    private String driver;
    @JsonProperty(value="ExecDriver")
    private String execDriver;
    @JsonProperty(value="ProcessLabel")
    private String processLabel;
    @JsonProperty(value="MountLabel")
    private String mountLabel;
    @JsonProperty(value="Volumes")
    private ImmutableMap<String, String> volumes;
    @JsonProperty(value="VolumesRW")
    private ImmutableMap<String, Boolean> volumesRW;
    @JsonProperty(value="AppArmorProfile")
    private String appArmorProfile;
    @JsonProperty(value="ExecIDs")
    private ImmutableList<String> execId;
    @JsonProperty(value="LogPath")
    private String logPath;
    @JsonProperty(value="RestartCount")
    private Long restartCount;
    @JsonProperty(value="Mounts")
    private ImmutableList<ContainerMount> mounts;
    @JsonProperty(value="Node")
    private Node node;

    public String id() {
        return this.id;
    }

    public Date created() {
        return this.created == null ? null : new Date(this.created.getTime());
    }

    public String path() {
        return this.path;
    }

    public List<String> args() {
        return this.args;
    }

    public ContainerConfig config() {
        return this.config;
    }

    public HostConfig hostConfig() {
        return this.hostConfig;
    }

    public ContainerState state() {
        return this.state;
    }

    public String image() {
        return this.image;
    }

    public NetworkSettings networkSettings() {
        return this.networkSettings;
    }

    public String resolvConfPath() {
        return this.resolvConfPath;
    }

    public String hostnamePath() {
        return this.hostnamePath;
    }

    public String hostsPath() {
        return this.hostsPath;
    }

    public String name() {
        return this.name;
    }

    public String driver() {
        return this.driver;
    }

    public String execDriver() {
        return this.execDriver;
    }

    public String processLabel() {
        return this.processLabel;
    }

    public String mountLabel() {
        return this.mountLabel;
    }

    @Deprecated
    public Map<String, String> volumes() {
        return this.volumes;
    }

    @Deprecated
    public Map<String, Boolean> volumesRW() {
        return this.volumesRW;
    }

    public Node node() {
        return this.node;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerInfo that = (ContainerInfo)o;
        if (this.args != null ? !this.args.equals(that.args) : that.args != null) {
            return false;
        }
        if (this.config != null ? !this.config.equals(that.config) : that.config != null) {
            return false;
        }
        if (this.hostConfig != null ? !this.hostConfig.equals(that.hostConfig) : that.hostConfig != null) {
            return false;
        }
        if (this.created != null ? !this.created.equals(that.created) : that.created != null) {
            return false;
        }
        if (this.driver != null ? !this.driver.equals(that.driver) : that.driver != null) {
            return false;
        }
        if (this.execDriver != null ? !this.execDriver.equals(that.execDriver) : that.execDriver != null) {
            return false;
        }
        if (this.hostnamePath != null ? !this.hostnamePath.equals(that.hostnamePath) : that.hostnamePath != null) {
            return false;
        }
        if (this.hostsPath != null ? !this.hostsPath.equals(that.hostsPath) : that.hostsPath != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.mountLabel != null ? !this.mountLabel.equals(that.mountLabel) : that.mountLabel != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.networkSettings != null ? !this.networkSettings.equals(that.networkSettings) : that.networkSettings != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.processLabel != null ? !this.processLabel.equals(that.processLabel) : that.processLabel != null) {
            return false;
        }
        if (this.resolvConfPath != null ? !this.resolvConfPath.equals(that.resolvConfPath) : that.resolvConfPath != null) {
            return false;
        }
        if (this.state != null ? !this.state.equals(that.state) : that.state != null) {
            return false;
        }
        if (this.volumes != null ? !this.volumes.equals(that.volumes) : that.volumes != null) {
            return false;
        }
        if (this.volumesRW != null ? !this.volumesRW.equals(that.volumesRW) : that.volumesRW != null) {
            return false;
        }
        if (this.node != null ? !this.node.equals(that.node) : that.node != null) {
            return false;
        }
        if (this.appArmorProfile != null ? !this.appArmorProfile.equals(that.appArmorProfile) : that.appArmorProfile != null) {
            return false;
        }
        if (this.execId != null ? !this.execId.equals(that.execId) : that.execId != null) {
            return false;
        }
        if (this.logPath != null ? !this.logPath.equals(that.logPath) : that.logPath != null) {
            return false;
        }
        if (this.restartCount != null ? !this.restartCount.equals(that.restartCount) : that.restartCount != null) {
            return false;
        }
        return !(this.mounts != null ? !this.mounts.equals(that.mounts) : that.mounts != null);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.created, this.path, this.args, this.config, this.hostConfig, this.state, this.image, this.networkSettings, this.resolvConfPath, this.hostnamePath, this.hostsPath, this.name, this.driver, this.execDriver, this.processLabel, this.mountLabel, this.volumes, this.volumesRW, this.node, this.appArmorProfile, this.execId, this.logPath, this.restartCount, this.mounts);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("created", (Object)this.created).add("path", (Object)this.path).add("args", this.args).add("config", (Object)this.config).add("hostConfig", (Object)this.hostConfig).add("state", (Object)this.state).add("image", (Object)this.image).add("networkSettings", (Object)this.networkSettings).add("resolvConfPath", (Object)this.resolvConfPath).add("hostnamePath", (Object)this.hostnamePath).add("hostsPath", (Object)this.hostsPath).add("name", (Object)this.name).add("driver", (Object)this.driver).add("execDriver", (Object)this.execDriver).add("processLabel", (Object)this.processLabel).add("mountLabel", (Object)this.mountLabel).add("volumes", this.volumes).add("volumesRW", this.volumesRW).add("node", (Object)this.node).add("appArmorProfile", (Object)this.appArmorProfile).add("execIDs", this.execId).add("logPath", (Object)this.logPath).add("restartCount", (Object)this.restartCount).add("mounts", this.mounts).toString();
    }

    public String appArmorProfile() {
        return this.appArmorProfile;
    }

    public List<String> execId() {
        return this.execId;
    }

    public String logPath() {
        return this.logPath;
    }

    public Long restartCount() {
        return this.restartCount;
    }

    public List<ContainerMount> mounts() {
        return this.mounts;
    }

    public static class Node {
        @JsonProperty(value="Id")
        private String id;
        @JsonProperty(value="Ip")
        private String ip;
        @JsonProperty(value="Addr")
        private String addr;
        @JsonProperty(value="Name")
        private String name;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getIp() {
            return this.ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public String getAddr() {
            return this.addr;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return Objects.equals(this.id, node.id) && Objects.equals(this.ip, node.ip) && Objects.equals(this.addr, node.addr) && Objects.equals(this.name, node.name);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.ip, this.addr, this.name);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("ip", (Object)this.ip).add("addr", (Object)this.addr).add("name", (Object)this.name).toString();
        }
    }
}

