/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Objects;
import org.glassfish.jersey.internal.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class AuthConfig {
    private static final Logger log = LoggerFactory.getLogger(AuthConfig.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    @JsonProperty(value="Username")
    private String username;
    @JsonProperty(value="Password")
    private String password;
    @JsonProperty(value="Email")
    private String email;
    @JsonProperty(value="ServerAddress")
    private String serverAddress;

    private AuthConfig() {
    }

    private AuthConfig(Builder builder) {
        this.username = builder.username;
        this.password = builder.password;
        this.email = builder.email;
        this.serverAddress = builder.serverAddress;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public String email() {
        return this.email;
    }

    public String serverAddress() {
        return this.serverAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthConfig config = (AuthConfig)o;
        if (this.username != null ? !this.username.equals(config.username) : config.username != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(config.password) : config.password != null) {
            return false;
        }
        if (this.email != null ? !this.email.equals(config.email) : config.email != null) {
            return false;
        }
        return !(this.serverAddress != null ? !this.serverAddress.equals(config.serverAddress) : config.serverAddress != null);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.password, this.email, this.serverAddress);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("username", (Object)this.username).add("password", (Object)this.password).add("email", (Object)this.email).add("serverAddress", (Object)this.serverAddress).toString();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder fromDockerConfig() throws IOException {
        return AuthConfig.parseDockerConfig(AuthConfig.defaultConfigPath(), null);
    }

    public static Builder fromDockerConfig(String serverAddress) throws IOException {
        return AuthConfig.parseDockerConfig(AuthConfig.defaultConfigPath(), serverAddress);
    }

    @VisibleForTesting
    static Builder fromDockerConfig(Path configPath) throws IOException {
        return AuthConfig.parseDockerConfig(configPath, null);
    }

    @VisibleForTesting
    static Builder fromDockerConfig(Path configPath, String serverAddress) throws IOException {
        return AuthConfig.parseDockerConfig(configPath, serverAddress);
    }

    private static Path defaultConfigPath() {
        String home = System.getProperty("user.home");
        Path dockerConfig = Paths.get(home, ".docker", "config.json");
        Path dockerCfg = Paths.get(home, ".dockercfg");
        if (Files.exists(dockerConfig, new LinkOption[0])) {
            log.debug("Using configfile: {}", (Object)dockerConfig);
            return dockerConfig;
        }
        if (Files.exists(dockerCfg, new LinkOption[0])) {
            log.debug("Using configfile: {} ", (Object)dockerCfg);
            return dockerCfg;
        }
        throw new RuntimeException("Could not find a docker config. Please run 'docker login' to create one");
    }

    private static Builder parseDockerConfig(Path configPath, String serverAddress) throws IOException {
        String[] authParams;
        Preconditions.checkNotNull((Object)configPath);
        Builder authBuilder = AuthConfig.builder();
        JsonNode authJson = AuthConfig.extractAuthJson(configPath);
        if (Strings.isNullOrEmpty((String)serverAddress)) {
            Iterator servers = authJson.fieldNames();
            if (servers.hasNext()) {
                serverAddress = (String)servers.next();
            }
        } else if (!authJson.has(serverAddress)) {
            log.error("Could not find auth config for {}. Returning empty builder", (Object)serverAddress);
            return AuthConfig.builder().serverAddress(serverAddress);
        }
        JsonNode serverAuth = authJson.get(serverAddress);
        if (serverAuth != null && serverAuth.has("auth")) {
            authBuilder.serverAddress(serverAddress);
            String authString = serverAuth.get("auth").asText();
            authParams = Base64.decodeAsString((String)authString).split(":");
            if (authParams.length != 2) {
                log.warn("Failed to parse auth string for {}", (Object)serverAddress);
                return authBuilder;
            }
        } else {
            log.warn("Could not find auth field for {}", (Object)serverAddress);
            return authBuilder;
        }
        authBuilder.username(authParams[0].trim());
        authBuilder.password(authParams[1].trim());
        if (serverAuth.has("email")) {
            authBuilder.email(serverAuth.get("email").asText());
        }
        return authBuilder;
    }

    private static JsonNode extractAuthJson(Path configPath) throws IOException {
        JsonNode config = MAPPER.readTree(configPath.toFile());
        if (config.has("auths")) {
            return config.get("auths");
        }
        return config;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String username;
        private String password;
        private String email;
        private String serverAddress = "https://index.docker.io/v1/";

        private Builder() {
        }

        private Builder(AuthConfig config) {
            this.username = config.username;
            this.password = config.password;
            this.email = config.email;
            this.serverAddress = config.serverAddress;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public String username() {
            return this.username;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public String password() {
            return this.password;
        }

        public Builder email(String email) {
            this.email = email;
            return this;
        }

        public String email() {
            return this.email;
        }

        public Builder serverAddress(String serverAddress) {
            this.serverAddress = serverAddress;
            return this;
        }

        public String serverAddress() {
            return this.serverAddress;
        }

        public AuthConfig build() {
            return new AuthConfig(this);
        }
    }
}

