/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.spotify.docker.client.messages.BlockIoStats;
import com.spotify.docker.client.messages.CpuStats;
import com.spotify.docker.client.messages.MemoryStats;
import com.spotify.docker.client.messages.NetworkStats;
import java.util.Map;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class ContainerStats {
    @JsonProperty(value="read")
    private String read;
    @JsonProperty(value="network")
    private NetworkStats network;
    @JsonProperty(value="networks")
    private ImmutableMap<String, NetworkStats> networks;
    @JsonProperty(value="memory_stats")
    private MemoryStats memoryStats;
    @JsonProperty(value="blkio_stats")
    private BlockIoStats blockIoStats;
    @JsonProperty(value="cpu_stats")
    private CpuStats cpuStats;
    @JsonProperty(value="precpu_stats")
    private CpuStats precpuStats;

    public String read() {
        return this.read;
    }

    public NetworkStats network() {
        return this.network;
    }

    public Map<String, NetworkStats> networks() {
        return this.networks;
    }

    public MemoryStats memoryStats() {
        return this.memoryStats;
    }

    public BlockIoStats blockIoStats() {
        return this.blockIoStats;
    }

    public CpuStats cpuStats() {
        return this.cpuStats;
    }

    public CpuStats precpuStats() {
        return this.precpuStats;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cpuStats == null ? 0 : this.cpuStats.hashCode());
        result = 31 * result + (this.memoryStats == null ? 0 : this.memoryStats.hashCode());
        result = 31 * result + (this.network == null ? 0 : this.network.hashCode());
        result = 31 * result + (this.networks == null ? 0 : this.networks.hashCode());
        result = 31 * result + (this.blockIoStats == null ? 0 : this.blockIoStats.hashCode());
        result = 31 * result + (this.precpuStats == null ? 0 : this.precpuStats.hashCode());
        result = 31 * result + (this.read == null ? 0 : this.read.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContainerStats other = (ContainerStats)obj;
        if (this.cpuStats == null ? other.cpuStats != null : !this.cpuStats.equals(other.cpuStats)) {
            return false;
        }
        if (this.memoryStats == null ? other.memoryStats != null : !this.memoryStats.equals(other.memoryStats)) {
            return false;
        }
        if (this.network == null ? other.network != null : !this.network.equals(other.network)) {
            return false;
        }
        if (this.networks == null ? other.networks != null : !this.networks.equals(other.networks)) {
            return false;
        }
        if (this.blockIoStats == null ? other.blockIoStats != null : !this.blockIoStats.equals(other.blockIoStats)) {
            return false;
        }
        if (this.precpuStats == null ? other.precpuStats != null : !this.precpuStats.equals(other.precpuStats)) {
            return false;
        }
        return !(this.read == null ? other.read != null : !this.read.equals(other.read));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("cpuStats", (Object)this.cpuStats).add("memoryStats", (Object)this.memoryStats).add("network", (Object)this.network).add("networks", this.networks).add("blkioStats", (Object)this.blockIoStats).add("precpuStats", (Object)this.precpuStats).add("read", (Object)this.read).toString();
    }
}

