/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.net.HostAndPort;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Locale;

public class DockerHost {
    private static SystemDelegate systemDelegate = new SystemDelegate(){

        @Override
        public String getProperty(String key) {
            return System.getProperty(key);
        }

        @Override
        public String getenv(String name) {
            return System.getenv(name);
        }
    };
    private static final String DEFAULT_UNIX_ENDPOINT = "unix:///var/run/docker.sock";
    private static final String DEFAULT_ADDRESS = "localhost";
    private static final int DEFAULT_PORT = 2375;
    private final String host;
    private final URI uri;
    private final URI bindURI;
    private final String address;
    private final int port;
    private final String certPath;

    private DockerHost(String endpoint, String certPath) {
        if (endpoint.startsWith("unix://")) {
            this.port = 0;
            this.address = DEFAULT_ADDRESS;
            this.host = endpoint;
            this.uri = URI.create(endpoint);
            this.bindURI = URI.create(endpoint);
        } else {
            String stripped = endpoint.replaceAll(".*://", "");
            HostAndPort hostAndPort = HostAndPort.fromString((String)stripped);
            String hostText = hostAndPort.getHostText();
            String scheme = Strings.isNullOrEmpty((String)certPath) ? "http" : "https";
            this.port = hostAndPort.getPortOrDefault(DockerHost.defaultPort());
            this.address = Strings.isNullOrEmpty((String)hostText) ? DEFAULT_ADDRESS : hostText;
            this.host = this.address + ":" + this.port;
            this.uri = URI.create(scheme + "://" + this.address + ":" + this.port);
            this.bindURI = URI.create("tcp://" + this.address + ":" + this.port);
        }
        this.certPath = certPath;
    }

    public String host() {
        return this.host;
    }

    public URI uri() {
        return this.uri;
    }

    public URI bindURI() {
        return this.bindURI;
    }

    public int port() {
        return this.port;
    }

    public String address() {
        return this.address;
    }

    public String dockerCertPath() {
        return this.certPath;
    }

    @VisibleForTesting
    static void setSystemDelegate(SystemDelegate delegate) {
        systemDelegate = delegate;
    }

    public static DockerHost fromEnv() {
        String host = DockerHost.endpointFromEnv();
        String certPath = DockerHost.certPathFromEnv();
        return new DockerHost(host, certPath);
    }

    public static DockerHost from(String endpoint, String certPath) {
        return new DockerHost(endpoint, certPath);
    }

    static String defaultDockerEndpoint() {
        String osName = systemDelegate.getProperty("os.name");
        String os = osName.toLowerCase(Locale.ENGLISH);
        if (os.equalsIgnoreCase("linux") || os.contains("mac")) {
            return DEFAULT_UNIX_ENDPOINT;
        }
        return "localhost:" + DockerHost.defaultPort();
    }

    static String endpointFromEnv() {
        return (String)MoreObjects.firstNonNull((Object)systemDelegate.getenv("DOCKER_HOST"), (Object)DockerHost.defaultDockerEndpoint());
    }

    public static String defaultUnixEndpoint() {
        return DEFAULT_UNIX_ENDPOINT;
    }

    public static String defaultAddress() {
        return DEFAULT_ADDRESS;
    }

    public static int defaultPort() {
        return 2375;
    }

    static int portFromEnv() {
        String port = systemDelegate.getenv("DOCKER_PORT");
        if (port == null) {
            return DockerHost.defaultPort();
        }
        try {
            return Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            return DockerHost.defaultPort();
        }
    }

    static String defaultCertPath() {
        String userHome = systemDelegate.getProperty("user.home");
        return Paths.get(userHome, ".docker").toString();
    }

    static String certPathFromEnv() {
        return (String)MoreObjects.firstNonNull((Object)systemDelegate.getenv("DOCKER_CERT_PATH"), (Object)DockerHost.defaultCertPath());
    }

    public String toString() {
        return "DockerHost{host='" + this.host + '\'' + ", uri=" + this.uri + ", bindURI=" + this.bindURI + ", address='" + this.address + '\'' + ", port=" + this.port + ", certPath='" + this.certPath + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerHost that = (DockerHost)o;
        if (this.port != that.port) {
            return false;
        }
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (this.uri != null ? !this.uri.equals(that.uri) : that.uri != null) {
            return false;
        }
        if (this.bindURI != null ? !this.bindURI.equals(that.bindURI) : that.bindURI != null) {
            return false;
        }
        if (this.address != null ? !this.address.equals(that.address) : that.address != null) {
            return false;
        }
        return this.certPath != null ? this.certPath.equals(that.certPath) : that.certPath == null;
    }

    public int hashCode() {
        int result = this.host != null ? this.host.hashCode() : 0;
        result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
        result = 31 * result + (this.bindURI != null ? this.bindURI.hashCode() : 0);
        result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
        result = 31 * result + this.port;
        result = 31 * result + (this.certPath != null ? this.certPath.hashCode() : 0);
        return result;
    }

    @VisibleForTesting
    static interface SystemDelegate {
        public String getProperty(String var1);

        public String getenv(String var1);
    }
}

