/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.collect.AbstractIterator;
import com.google.common.io.Closer;
import com.spotify.docker.client.LogMessage;
import com.spotify.docker.client.LogReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogStream
extends AbstractIterator<LogMessage>
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(LogStream.class);
    private final LogReader reader;
    private volatile boolean closed;

    LogStream(InputStream stream) {
        this.reader = new LogReader(stream);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.closed) {
            log.warn(this + " not closed properly");
            this.close();
        }
    }

    protected LogMessage computeNext() {
        LogMessage message;
        try {
            message = this.reader.nextMessage();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        if (message == null) {
            return (LogMessage)this.endOfData();
        }
        return message;
    }

    @Override
    public void close() {
        this.closed = true;
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public String readFully() {
        StringBuilder stringBuilder = new StringBuilder();
        while (this.hasNext()) {
            stringBuilder.append(Charsets.UTF_8.decode(((LogMessage)this.next()).content()));
        }
        return stringBuilder.toString();
    }

    public void attach(OutputStream stdout, OutputStream stderr) throws IOException {
        this.attach(stdout, stderr, true);
    }

    public void attach(OutputStream stdout, OutputStream stderr, boolean closeAtEOF) throws IOException {
        try (Closer closer = Closer.create();){
            if (closeAtEOF) {
                closer.register((Closeable)stdout);
                closer.register((Closeable)stderr);
            }
            while (this.hasNext()) {
                LogMessage message = (LogMessage)this.next();
                ByteBuffer content = message.content();
                assert (content.hasArray());
                switch (message.stream()) {
                    case STDOUT: {
                        stdout.write(content.array(), content.position(), content.remaining());
                        stdout.flush();
                        break;
                    }
                    case STDERR: {
                        stderr.write(content.array(), content.position(), content.remaining());
                        stderr.flush();
                        break;
                    }
                }
            }
        }
    }
}

