/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.spotify.docker.client.messages.swarm.EndpointSpec;
import com.spotify.docker.client.messages.swarm.NetworkAttachmentConfig;
import com.spotify.docker.client.messages.swarm.ServiceMode;
import com.spotify.docker.client.messages.swarm.TaskSpec;
import com.spotify.docker.client.messages.swarm.UpdateConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class ServiceSpec {
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="Labels")
    private Map<String, String> labels;
    @JsonProperty(value="TaskTemplate")
    private TaskSpec taskTemplate;
    @JsonProperty(value="Mode")
    private ServiceMode mode;
    @JsonProperty(value="UpdateConfig")
    private UpdateConfig updateConfig;
    @JsonProperty(value="Networks")
    private ImmutableList<NetworkAttachmentConfig> networks;
    @JsonProperty(value="EndpointSpec")
    private EndpointSpec endpointSpec;

    public String name() {
        return this.name;
    }

    public Map<String, String> labels() {
        return this.labels;
    }

    public TaskSpec taskTemplate() {
        return this.taskTemplate;
    }

    public ServiceMode mode() {
        return this.mode;
    }

    public UpdateConfig updateConfig() {
        return this.updateConfig;
    }

    public List<NetworkAttachmentConfig> networks() {
        return this.networks;
    }

    public EndpointSpec endpointSpec() {
        return this.endpointSpec;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceSpec that = (ServiceSpec)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.labels, that.labels) && Objects.equals(this.taskTemplate, that.taskTemplate) && Objects.equals(this.mode, that.mode) && Objects.equals(this.updateConfig, that.updateConfig) && Objects.equals(this.networks, that.networks) && Objects.equals(this.endpointSpec, that.endpointSpec);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.labels, this.taskTemplate, this.mode, this.updateConfig, this.networks, this.endpointSpec);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("labels", this.labels).add("taskTemplate", (Object)this.taskTemplate).add("mode", (Object)this.mode).add("updateConfig", (Object)this.updateConfig).add("networks", this.networks).add("endpointSpec", (Object)this.endpointSpec).toString();
    }

    public static class Builder {
        private ServiceSpec spec = new ServiceSpec();

        public Builder withName(String name) {
            this.spec.name = name;
            return this;
        }

        public Builder withLabel(String label, String value) {
            if (this.spec.labels == null) {
                this.spec.labels = new HashMap();
            }
            this.spec.labels.put(label, value);
            return this;
        }

        public Builder withLabels(Map<String, String> labels) {
            if (this.spec.labels == null) {
                this.spec.labels = new HashMap();
            }
            this.spec.labels.putAll(labels);
            return this;
        }

        public Builder withTaskTemplate(TaskSpec taskTemplate) {
            this.spec.taskTemplate = taskTemplate;
            return this;
        }

        public Builder withServiceMode(ServiceMode mode) {
            this.spec.mode = mode;
            return this;
        }

        public Builder withUpdateConfig(UpdateConfig updateConfig) {
            this.spec.updateConfig = updateConfig;
            return this;
        }

        public Builder withNetworks(NetworkAttachmentConfig ... networks) {
            this.spec.networks = ImmutableList.copyOf((Object[])networks);
            return this;
        }

        public Builder withNetworks(List<NetworkAttachmentConfig> networks) {
            this.spec.networks = ImmutableList.copyOf(networks);
            return this;
        }

        public Builder withEndpointSpec(EndpointSpec endpointSpec) {
            this.spec.endpointSpec = endpointSpec;
            return this;
        }

        public ServiceSpec build() {
            return this.spec;
        }
    }
}

