/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Date;
import java.util.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class ContainerState {
    @JsonProperty(value="Status")
    private String status;
    @JsonProperty(value="Running")
    private Boolean running;
    @JsonProperty(value="Paused")
    private Boolean paused;
    @JsonProperty(value="Restarting")
    private Boolean restarting;
    @JsonProperty(value="Pid")
    private Integer pid;
    @JsonProperty(value="ExitCode")
    private Integer exitCode;
    @JsonProperty(value="StartedAt")
    private Date startedAt;
    @JsonProperty(value="FinishedAt")
    private Date finishedAt;
    @JsonProperty(value="Error")
    private String error;
    @JsonProperty(value="OOMKilled")
    private Boolean oomKilled;

    public String status() {
        return this.status;
    }

    public Boolean running() {
        return this.running;
    }

    public Boolean paused() {
        return this.paused;
    }

    public Boolean restarting() {
        return this.restarting;
    }

    public Integer pid() {
        return this.pid;
    }

    public Integer exitCode() {
        return this.exitCode;
    }

    public Date startedAt() {
        return this.startedAt == null ? null : new Date(this.startedAt.getTime());
    }

    public Date finishedAt() {
        return this.finishedAt == null ? null : new Date(this.finishedAt.getTime());
    }

    public String error() {
        return this.error;
    }

    public Boolean oomKilled() {
        return this.oomKilled;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ContainerState that = (ContainerState)obj;
        return Objects.equals(this.status, that.status) && Objects.equals(this.running, that.running) && Objects.equals(this.paused, that.paused) && Objects.equals(this.restarting, that.restarting) && Objects.equals(this.pid, that.pid) && Objects.equals(this.exitCode, that.exitCode) && Objects.equals(this.startedAt, that.startedAt) && Objects.equals(this.finishedAt, that.finishedAt) && Objects.equals(this.error, that.error) && Objects.equals(this.oomKilled, that.oomKilled);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.running, this.pid, this.paused, this.restarting, this.exitCode, this.startedAt, this.finishedAt, this.error, this.oomKilled);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("status", (Object)this.status).add("running", (Object)this.running).add("pid", (Object)this.pid).add("paused", (Object)this.paused).add("restarting", (Object)this.restarting).add("exitCode", (Object)this.exitCode).add("startedAt", (Object)this.startedAt).add("finishedAt", (Object)this.finishedAt).add("error", (Object)this.error).add("oomKilled", (Object)this.oomKilled).toString();
    }
}

