/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class RestartPolicy {
    public static final String RESTART_POLICY_NONE = "none";
    public static final String RESTART_POLICY_ON_FAILURE = "on-failure";
    public static final String RESTART_POLICY_ANY = "any";
    @JsonProperty(value="Condition")
    private String condition;
    @JsonProperty(value="Delay")
    private Long delay;
    @JsonProperty(value="MaxAttempts")
    private Integer maxAttempts;
    @JsonProperty(value="Window")
    private Long window;

    public String condition() {
        return this.condition;
    }

    public Long delay() {
        return this.delay;
    }

    public Integer maxAttempts() {
        return this.maxAttempts;
    }

    public Long window() {
        return this.window;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RestartPolicy that = (RestartPolicy)obj;
        return Objects.equals(this.condition, that.condition) && Objects.equals(this.delay, that.delay) && Objects.equals(this.maxAttempts, that.maxAttempts) && Objects.equals(this.window, that.window);
    }

    public int hashCode() {
        return Objects.hash(this.condition, this.delay, this.maxAttempts, this.window);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("condition", (Object)this.condition).add("delay", (Object)this.delay).add("maxAttempts", (Object)this.maxAttempts).add("window", (Object)this.window).toString();
    }

    public static class Builder {
        private RestartPolicy restart = new RestartPolicy();

        public Builder withCondition(String condition) {
            this.restart.condition = condition;
            return this;
        }

        public Builder withDelay(long delay) {
            this.restart.delay = delay;
            return this;
        }

        public Builder withMaxAttempts(int maxAttempts) {
            this.restart.maxAttempts = maxAttempts;
            return this;
        }

        public Builder withWindow(long window) {
            this.restart.window = window;
            return this;
        }

        public RestartPolicy build() {
            return this.restart;
        }
    }
}

