/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class LogConfig {
    @JsonProperty(value="Type")
    private String logType;
    @JsonProperty(value="Config")
    private Map<String, String> logOptions;

    private LogConfig() {
    }

    private LogConfig(String logType, Map<String, String> logOptions) {
        this.logType = logType;
        this.logOptions = ImmutableMap.copyOf(logOptions);
    }

    public String logType() {
        return this.logType;
    }

    public Map<String, String> logOptions() {
        return this.logOptions == null ? null : Collections.unmodifiableMap(this.logOptions);
    }

    public static LogConfig create(String logType) {
        return LogConfig.create(logType, Collections.emptyMap());
    }

    public static LogConfig create(String logType, Map<String, String> logOptions) {
        return new LogConfig(logType, logOptions);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LogConfig that = (LogConfig)obj;
        return Objects.equals(this.logType, that.logType) && Objects.equals(this.logOptions, that.logOptions);
    }

    public int hashCode() {
        return Objects.hash(this.logType, this.logOptions);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Type", (Object)this.logType).add("Config", this.logOptions).toString();
    }
}

