/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.spotify.docker.client.messages.ProgressDetail;

public class ProgressMessage {
    private static final String STATUS_DIGEST_PREFIX_16 = "Digest: ";
    private static final String STATUS_DIGEST_PREFIX_18 = "digest: ";
    private static final String STATUS_SIZE_PREFIX_18 = "size: ";
    @JsonProperty
    private String id;
    @JsonProperty
    private String status;
    @JsonProperty
    private String stream;
    @JsonProperty
    private String error;
    @JsonProperty
    private String progress;
    @JsonProperty
    private ProgressDetail progressDetail;

    public String id() {
        return this.id;
    }

    public ProgressMessage id(String id) {
        this.id = id;
        return this;
    }

    public String status() {
        return this.status;
    }

    public ProgressMessage status(String status) {
        this.status = status;
        return this;
    }

    public String stream() {
        return this.stream;
    }

    public ProgressMessage stream(String stream) {
        this.stream = stream;
        return this;
    }

    public String error() {
        return this.error;
    }

    public ProgressMessage error(String error) {
        this.error = error;
        return this;
    }

    public String progress() {
        return this.progress;
    }

    public ProgressMessage progress(String progress) {
        this.progress = progress;
        return this;
    }

    public ProgressDetail progressDetail() {
        return this.progressDetail;
    }

    public ProgressMessage progressDetail(ProgressDetail progressDetail) {
        this.progressDetail = progressDetail;
        return this;
    }

    public String buildImageId() {
        return this.stream != null && this.stream.startsWith("Successfully built") ? this.stream.substring(this.stream.lastIndexOf(32) + 1).trim() : null;
    }

    public String digest() {
        if (this.status == null) {
            return null;
        }
        if (this.status.startsWith(STATUS_DIGEST_PREFIX_16)) {
            return this.status.substring(STATUS_DIGEST_PREFIX_16.length()).trim();
        }
        int digestIndex = this.status.indexOf(STATUS_DIGEST_PREFIX_18);
        int sizeIndex = this.status.indexOf(STATUS_SIZE_PREFIX_18);
        if (digestIndex > -1 && sizeIndex > digestIndex) {
            int start = digestIndex + STATUS_DIGEST_PREFIX_18.length();
            return this.status.substring(start, sizeIndex - 1);
        }
        return null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("status", (Object)this.status).add("stream", (Object)this.stream).add("error", (Object)this.error).add("progress", (Object)this.progress).add("progressDetail", (Object)this.progressDetail).toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ProgressMessage that = (ProgressMessage)obj;
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.status, (Object)that.status) && Objects.equal((Object)this.stream, (Object)that.stream) && Objects.equal((Object)this.error, (Object)that.error) && Objects.equal((Object)this.progress, (Object)that.progress) && Objects.equal((Object)this.progressDetail, (Object)that.progressDetail);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.status, this.stream, this.error, this.progress, this.progressDetail});
    }
}

