/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages.mount;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.spotify.docker.client.messages.mount.Driver;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class VolumeOptions {
    @JsonProperty(value="NoCopy")
    private Boolean noCopy;
    @JsonProperty(value="Labels")
    private Map<String, String> labels;
    @JsonProperty(value="DriverConfig")
    private Driver driverConfig;

    public Boolean noCopy() {
        return this.noCopy;
    }

    public Map<String, String> labels() {
        return this.labels;
    }

    public Driver driverConfig() {
        return this.driverConfig;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        VolumeOptions that = (VolumeOptions)obj;
        return Objects.equals(this.noCopy, that.noCopy) && Objects.equals(this.labels, that.labels) && Objects.equals(this.driverConfig, that.driverConfig);
    }

    public int hashCode() {
        return Objects.hash(this.noCopy, this.labels, this.driverConfig);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("noCopy", (Object)this.noCopy).add("labels", this.labels).add("driverConfig", (Object)this.driverConfig).toString();
    }

    public static class Builder {
        private VolumeOptions volume = new VolumeOptions();

        public Builder withNoCopy() {
            this.volume.noCopy = true;
            return this;
        }

        public Builder withNoCopy(boolean noCopy) {
            this.volume.noCopy = noCopy;
            return this;
        }

        public Builder withLabel(String label, String value) {
            if (this.volume.labels == null) {
                this.volume.labels = new HashMap();
            }
            this.volume.labels.put(label, value);
            return this;
        }

        public Builder withDriverConfig(Driver driverConfig) {
            this.volume.driverConfig = driverConfig;
            return this;
        }

        public VolumeOptions build() {
            return this.volume;
        }
    }
}

