/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.spotify.docker.client.messages.mount.Mount;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class ContainerSpec {
    @JsonProperty(value="Image")
    private String image;
    @JsonProperty(value="Labels")
    private Map<String, String> labels;
    @JsonProperty(value="Command")
    private ImmutableList<String> command;
    @JsonProperty(value="Args")
    private ImmutableList<String> args;
    @JsonProperty(value="Env")
    private ImmutableList<String> env;
    @JsonProperty(value="Dir")
    private String dir;
    @JsonProperty(value="User")
    private String user;
    @JsonProperty(value="Groups")
    private ImmutableList<String> groups;
    @JsonProperty(value="TTY")
    private Boolean tty;
    @JsonProperty(value="Mounts")
    private ImmutableList<Mount> mounts;
    @JsonProperty(value="StopGracePeriod")
    private Long stopGracePeriod;

    public String image() {
        return this.image;
    }

    public Map<String, String> labels() {
        return this.labels;
    }

    public List<String> command() {
        return this.command;
    }

    public List<String> args() {
        return this.args;
    }

    public List<String> env() {
        return this.env;
    }

    public String dir() {
        return this.dir;
    }

    public String user() {
        return this.user;
    }

    public List<String> groups() {
        return this.groups;
    }

    public Boolean tty() {
        return this.tty;
    }

    public List<Mount> mounts() {
        return this.mounts;
    }

    public Long stopGracePeriod() {
        return this.stopGracePeriod;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ContainerSpec that = (ContainerSpec)obj;
        return Objects.equals(this.image, that.image) && Objects.equals(this.labels, that.labels) && Objects.equals(this.command, that.command) && Objects.equals(this.args, that.args) && Objects.equals(this.env, that.env) && Objects.equals(this.dir, that.dir) && Objects.equals(this.user, that.user) && Objects.equals(this.groups, that.groups) && Objects.equals(this.tty, that.tty) && Objects.equals(this.mounts, that.mounts) && Objects.equals(this.stopGracePeriod, that.stopGracePeriod);
    }

    public int hashCode() {
        return Objects.hash(this.image, this.labels, this.command, this.args, this.env, this.dir, this.user, this.groups, this.tty, this.mounts, this.stopGracePeriod);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("image", (Object)this.image).add("labels", this.labels).add("command", this.command).add("args", this.args).add("env", this.env).add("dir", (Object)this.dir).add("user", (Object)this.user).add("groups", this.groups).add("tty", (Object)this.tty).add("mounts", this.mounts).add("stopGracePeriod", (Object)this.stopGracePeriod).toString();
    }

    public static class Builder {
        private ContainerSpec spec = new ContainerSpec();

        public Builder withImage(String image) {
            this.spec.image = image;
            return this;
        }

        public Builder withLabel(String label, String value) {
            if (this.spec.labels == null) {
                this.spec.labels = new HashMap();
            }
            this.spec.labels.put(label, value);
            return this;
        }

        public Builder withCommands(String ... commands) {
            if (commands != null && commands.length > 0) {
                this.spec.command = ImmutableList.copyOf((Object[])commands);
            }
            return this;
        }

        public Builder withCommands(List<String> commands) {
            if (commands != null && !commands.isEmpty()) {
                this.spec.command = ImmutableList.copyOf(commands);
            }
            return this;
        }

        public Builder withArgs(String ... args) {
            if (args != null && args.length > 0) {
                this.spec.args = ImmutableList.copyOf((Object[])args);
            }
            return this;
        }

        public Builder withArgs(List<String> args) {
            if (args != null && !args.isEmpty()) {
                this.spec.args = ImmutableList.copyOf(args);
            }
            return this;
        }

        public Builder withEnv(String ... env) {
            if (env != null && env.length > 0) {
                this.spec.env = ImmutableList.copyOf((Object[])env);
            }
            return this;
        }

        public Builder withEnv(List<String> env) {
            this.spec.env = ImmutableList.copyOf(env);
            return this;
        }

        public Builder withDir(String dir) {
            this.spec.dir = dir;
            return this;
        }

        public Builder withUser(String user) {
            this.spec.user = user;
            return this;
        }

        public Builder withGroups(String ... groups) {
            if (groups != null && groups.length > 0) {
                this.spec.groups = ImmutableList.copyOf((Object[])groups);
            }
            return this;
        }

        public Builder withGroups(List<String> groups) {
            if (groups != null && !groups.isEmpty()) {
                this.spec.groups = ImmutableList.copyOf(groups);
            }
            return this;
        }

        public Builder withTty() {
            this.spec.tty = true;
            return this;
        }

        public Builder withTty(boolean tty) {
            this.spec.tty = tty;
            return this;
        }

        public Builder withMounts(Mount ... mounts) {
            if (mounts != null && mounts.length > 0) {
                this.spec.mounts = ImmutableList.copyOf((Object[])mounts);
            }
            return this;
        }

        public Builder withMounts(List<Mount> mounts) {
            if (mounts != null && !mounts.isEmpty()) {
                this.spec.mounts = ImmutableList.copyOf(mounts);
            }
            return this;
        }

        public Builder withStopGracePeriod(long stopGracePeriod) {
            this.spec.stopGracePeriod = stopGracePeriod;
            return this;
        }

        public ContainerSpec build() {
            return this.spec;
        }
    }
}

