/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class Resources {
    @JsonProperty(value="NanoCPUs")
    private Long nanoCpus;
    @JsonProperty(value="MemoryBytes")
    private Long memoryBytes;

    public Long nanoCpus() {
        return this.nanoCpus;
    }

    public Long memoryBytes() {
        return this.memoryBytes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Resources that = (Resources)obj;
        return Objects.equals(this.nanoCpus, that.nanoCpus) && Objects.equals(this.memoryBytes, that.memoryBytes);
    }

    public int hashCode() {
        return Objects.hash(this.nanoCpus, this.memoryBytes);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("nanoCpus", (Object)this.nanoCpus).add("memoryBytes", (Object)this.memoryBytes).toString();
    }

    public static class Builder {
        private Resources resources = new Resources();

        public Builder withNanoCpus(Long nanoCpus) {
            this.resources.nanoCpus = nanoCpus;
            return this;
        }

        public Builder withMemoryBytes(Long memoryBytes) {
            this.resources.memoryBytes = memoryBytes;
            return this;
        }

        public Resources build() {
            return this.resources;
        }
    }
}

