/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.spotify.docker.client.jackson.UnixTimestampDeserializer;
import java.util.Date;
import java.util.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE)
public class Event {
    @JsonProperty(value="status")
    private String status;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="from")
    private String from;
    @JsonProperty(value="Type")
    private Type type;
    @JsonProperty(value="Action")
    private String action;
    @JsonProperty(value="Actor")
    private Actor actor;
    @JsonProperty(value="time")
    @JsonDeserialize(using=UnixTimestampDeserializer.class)
    private Date time;
    @JsonProperty(value="timeNano")
    private Long timeNano;

    @Deprecated
    public String status() {
        return this.status;
    }

    @Deprecated
    public String id() {
        return this.id;
    }

    @Deprecated
    public String from() {
        return this.from;
    }

    public Type type() {
        return this.type;
    }

    public String action() {
        return this.action;
    }

    public Actor actor() {
        return this.actor;
    }

    public Date time() {
        return this.time == null ? null : new Date(this.time.getTime());
    }

    public Long timeNano() {
        return this.timeNano;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Event that = (Event)obj;
        return Objects.equals(this.status, that.status) && Objects.equals(this.id, that.id) && Objects.equals(this.from, that.from) && Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.action, that.action) && Objects.equals(this.actor, that.actor) && Objects.equals(this.time, that.time) && Objects.equals(this.timeNano, that.timeNano);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.id, this.from, this.time);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("status", (Object)this.status).add("id", (Object)this.id).add("from", (Object)this.from).add("type", (Object)this.type).add("action", (Object)this.action).add("actor", (Object)this.actor).add("time", (Object)this.time).add("timeNano", (Object)this.timeNano).toString();
    }

    public static enum Type {
        CONTAINER("container"),
        IMAGE("image"),
        VOLUME("volume"),
        NETWORK("network"),
        DAEMON("daemon");

        private final String name;

        @JsonCreator
        private Type(String name) {
            this.name = name;
        }

        @JsonValue
        public String getName() {
            return this.name;
        }
    }

    public static class Actor {
        @JsonProperty(value="ID")
        private String id;
        @JsonProperty(value="Attributes")
        private ImmutableMap<String, String> attributes;

        public String id() {
            return this.id;
        }

        public ImmutableMap<String, String> attributes() {
            return this.attributes;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Actor that = (Actor)obj;
            return Objects.equals(this.id, that.id) && Objects.equals(this.attributes, that.attributes);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.attributes);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("attributes", this.attributes).toString();
        }
    }
}

