/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.spotify.docker.client.messages.swarm.PortConfig;
import java.util.List;
import java.util.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class EndpointSpec {
    public static final String RESOLUTION_MODE_VIP = "vip";
    public static final String RESOLUTION_MODE_DNSRR = "dnsrr";
    @JsonProperty(value="Mode")
    private String mode;
    @JsonProperty(value="Ports")
    private ImmutableList<PortConfig> ports;

    public String mode() {
        return this.mode;
    }

    public List<PortConfig> ports() {
        return this.ports;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EndpointSpec that = (EndpointSpec)obj;
        return Objects.equals(this.mode, that.mode) && Objects.equals(this.ports, that.ports);
    }

    public int hashCode() {
        return Objects.hash(this.mode, this.ports);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mode", (Object)this.mode).add("ports", this.ports).toString();
    }

    public static class Builder {
        private EndpointSpec spec = new EndpointSpec();

        public Builder withVipMode() {
            this.spec.mode = EndpointSpec.RESOLUTION_MODE_VIP;
            return this;
        }

        public Builder withDnsrrMode() {
            this.spec.mode = EndpointSpec.RESOLUTION_MODE_DNSRR;
            return this;
        }

        public Builder withPorts(PortConfig ... ports) {
            if (ports != null && ports.length > 0) {
                this.spec.ports = ImmutableList.copyOf((Object[])ports);
            }
            return this;
        }

        public Builder withPorts(List<PortConfig> ports) {
            if (ports != null && !ports.isEmpty()) {
                this.spec.ports = ImmutableList.copyOf(ports);
            }
            return this;
        }

        public EndpointSpec build() {
            return this.spec;
        }
    }
}

