
package com.spotify.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_Network extends Network {

  private final String name;
  private final String id;
  private final String scope;
  private final String driver;
  private final Ipam ipam;
  private final ImmutableMap<String, Network.Container> containers;
  private final ImmutableMap<String, String> options;

  AutoValue_Network(
      String name,
      String id,
      String scope,
      String driver,
      Ipam ipam,
      @Nullable ImmutableMap<String, Network.Container> containers,
      ImmutableMap<String, String> options) {
    if (name == null) {
      throw new NullPointerException("Null name");
    }
    this.name = name;
    if (id == null) {
      throw new NullPointerException("Null id");
    }
    this.id = id;
    if (scope == null) {
      throw new NullPointerException("Null scope");
    }
    this.scope = scope;
    if (driver == null) {
      throw new NullPointerException("Null driver");
    }
    this.driver = driver;
    if (ipam == null) {
      throw new NullPointerException("Null ipam");
    }
    this.ipam = ipam;
    this.containers = containers;
    if (options == null) {
      throw new NullPointerException("Null options");
    }
    this.options = options;
  }

  @JsonProperty(value = "Name")
  @Override
  public String name() {
    return name;
  }

  @JsonProperty(value = "Id")
  @Override
  public String id() {
    return id;
  }

  @JsonProperty(value = "Scope")
  @Override
  public String scope() {
    return scope;
  }

  @JsonProperty(value = "Driver")
  @Override
  public String driver() {
    return driver;
  }

  @JsonProperty(value = "IPAM")
  @Override
  public Ipam ipam() {
    return ipam;
  }

  @Nullable
  @JsonProperty(value = "Containers")
  @Override
  public ImmutableMap<String, Network.Container> containers() {
    return containers;
  }

  @JsonProperty(value = "Options")
  @Override
  public ImmutableMap<String, String> options() {
    return options;
  }

  @Override
  public String toString() {
    return "Network{"
        + "name=" + name + ", "
        + "id=" + id + ", "
        + "scope=" + scope + ", "
        + "driver=" + driver + ", "
        + "ipam=" + ipam + ", "
        + "containers=" + containers + ", "
        + "options=" + options
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Network) {
      Network that = (Network) o;
      return (this.name.equals(that.name()))
           && (this.id.equals(that.id()))
           && (this.scope.equals(that.scope()))
           && (this.driver.equals(that.driver()))
           && (this.ipam.equals(that.ipam()))
           && ((this.containers == null) ? (that.containers() == null) : this.containers.equals(that.containers()))
           && (this.options.equals(that.options()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.name.hashCode();
    h *= 1000003;
    h ^= this.id.hashCode();
    h *= 1000003;
    h ^= this.scope.hashCode();
    h *= 1000003;
    h ^= this.driver.hashCode();
    h *= 1000003;
    h ^= this.ipam.hashCode();
    h *= 1000003;
    h ^= (containers == null) ? 0 : this.containers.hashCode();
    h *= 1000003;
    h ^= this.options.hashCode();
    return h;
  }

}
