/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.spotify.docker.client.messages.AttachedNetwork;
import com.spotify.docker.client.messages.NetworkSettings;
import com.spotify.docker.client.messages.PortBinding;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

final class AutoValue_NetworkSettings
extends NetworkSettings {
    private final String ipAddress;
    private final Integer ipPrefixLen;
    private final String gateway;
    private final String bridge;
    private final ImmutableMap<String, Map<String, String>> portMapping;
    private final ImmutableMap<String, List<PortBinding>> ports;
    private final String macAddress;
    private final ImmutableMap<String, AttachedNetwork> networks;

    private AutoValue_NetworkSettings(@Nullable String ipAddress, @Nullable Integer ipPrefixLen, @Nullable String gateway, @Nullable String bridge, @Nullable ImmutableMap<String, Map<String, String>> portMapping, @Nullable ImmutableMap<String, List<PortBinding>> ports, @Nullable String macAddress, @Nullable ImmutableMap<String, AttachedNetwork> networks) {
        this.ipAddress = ipAddress;
        this.ipPrefixLen = ipPrefixLen;
        this.gateway = gateway;
        this.bridge = bridge;
        this.portMapping = portMapping;
        this.ports = ports;
        this.macAddress = macAddress;
        this.networks = networks;
    }

    @Override
    @Nullable
    @JsonProperty(value="IPAddress")
    public String ipAddress() {
        return this.ipAddress;
    }

    @Override
    @Nullable
    @JsonProperty(value="IPPrefixLen")
    public Integer ipPrefixLen() {
        return this.ipPrefixLen;
    }

    @Override
    @Nullable
    @JsonProperty(value="Gateway")
    public String gateway() {
        return this.gateway;
    }

    @Override
    @Nullable
    @JsonProperty(value="Bridge")
    public String bridge() {
        return this.bridge;
    }

    @Override
    @Nullable
    @JsonProperty(value="PortMapping")
    public ImmutableMap<String, Map<String, String>> portMapping() {
        return this.portMapping;
    }

    @Override
    @Nullable
    @JsonProperty(value="Ports")
    public ImmutableMap<String, List<PortBinding>> ports() {
        return this.ports;
    }

    @Override
    @Nullable
    @JsonProperty(value="MacAddress")
    public String macAddress() {
        return this.macAddress;
    }

    @Override
    @Nullable
    @JsonProperty(value="Networks")
    public ImmutableMap<String, AttachedNetwork> networks() {
        return this.networks;
    }

    public String toString() {
        return "NetworkSettings{ipAddress=" + this.ipAddress + ", " + "ipPrefixLen=" + this.ipPrefixLen + ", " + "gateway=" + this.gateway + ", " + "bridge=" + this.bridge + ", " + "portMapping=" + this.portMapping + ", " + "ports=" + this.ports + ", " + "macAddress=" + this.macAddress + ", " + "networks=" + this.networks + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NetworkSettings) {
            NetworkSettings that = (NetworkSettings)o;
            return (this.ipAddress == null ? that.ipAddress() == null : this.ipAddress.equals(that.ipAddress())) && (this.ipPrefixLen == null ? that.ipPrefixLen() == null : this.ipPrefixLen.equals(that.ipPrefixLen())) && (this.gateway == null ? that.gateway() == null : this.gateway.equals(that.gateway())) && (this.bridge == null ? that.bridge() == null : this.bridge.equals(that.bridge())) && (this.portMapping == null ? that.portMapping() == null : this.portMapping.equals(that.portMapping())) && (this.ports == null ? that.ports() == null : this.ports.equals(that.ports())) && (this.macAddress == null ? that.macAddress() == null : this.macAddress.equals(that.macAddress())) && (this.networks == null ? that.networks() == null : this.networks.equals(that.networks()));
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.ipAddress == null ? 0 : this.ipAddress.hashCode();
        h *= 1000003;
        h ^= this.ipPrefixLen == null ? 0 : this.ipPrefixLen.hashCode();
        h *= 1000003;
        h ^= this.gateway == null ? 0 : this.gateway.hashCode();
        h *= 1000003;
        h ^= this.bridge == null ? 0 : this.bridge.hashCode();
        h *= 1000003;
        h ^= this.portMapping == null ? 0 : this.portMapping.hashCode();
        h *= 1000003;
        h ^= this.ports == null ? 0 : this.ports.hashCode();
        h *= 1000003;
        h ^= this.macAddress == null ? 0 : this.macAddress.hashCode();
        h *= 1000003;
        return h ^= this.networks == null ? 0 : this.networks.hashCode();
    }

    static final class Builder
    extends NetworkSettings.Builder {
        private String ipAddress;
        private Integer ipPrefixLen;
        private String gateway;
        private String bridge;
        private ImmutableMap<String, Map<String, String>> portMapping;
        private ImmutableMap<String, List<PortBinding>> ports;
        private String macAddress;
        private ImmutableMap<String, AttachedNetwork> networks;

        Builder() {
        }

        Builder(NetworkSettings source) {
            this.ipAddress = source.ipAddress();
            this.ipPrefixLen = source.ipPrefixLen();
            this.gateway = source.gateway();
            this.bridge = source.bridge();
            this.portMapping = source.portMapping();
            this.ports = source.ports();
            this.macAddress = source.macAddress();
            this.networks = source.networks();
        }

        @Override
        public NetworkSettings.Builder ipAddress(@Nullable String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        @Override
        public NetworkSettings.Builder ipPrefixLen(@Nullable Integer ipPrefixLen) {
            this.ipPrefixLen = ipPrefixLen;
            return this;
        }

        @Override
        public NetworkSettings.Builder gateway(@Nullable String gateway) {
            this.gateway = gateway;
            return this;
        }

        @Override
        public NetworkSettings.Builder bridge(@Nullable String bridge) {
            this.bridge = bridge;
            return this;
        }

        @Override
        public NetworkSettings.Builder portMapping(@Nullable Map<String, Map<String, String>> portMapping) {
            this.portMapping = portMapping == null ? null : ImmutableMap.copyOf(portMapping);
            return this;
        }

        @Override
        public NetworkSettings.Builder ports(@Nullable Map<String, List<PortBinding>> ports) {
            this.ports = ports == null ? null : ImmutableMap.copyOf(ports);
            return this;
        }

        @Override
        public NetworkSettings.Builder macAddress(@Nullable String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        @Override
        public NetworkSettings.Builder networks(@Nullable Map<String, AttachedNetwork> networks) {
            this.networks = networks == null ? null : ImmutableMap.copyOf(networks);
            return this;
        }

        @Override
        public NetworkSettings build() {
            return new AutoValue_NetworkSettings(this.ipAddress, this.ipPrefixLen, this.gateway, this.bridge, this.portMapping, this.ports, this.macAddress, this.networks);
        }
    }
}

