/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.spotify.docker.client.messages.AutoValue_ContainerConfig;
import com.spotify.docker.client.messages.HostConfig;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public abstract class ContainerConfig {
    @Nullable
    @JsonProperty(value="Hostname")
    public abstract String hostname();

    @Nullable
    @JsonProperty(value="Domainname")
    public abstract String domainname();

    @Nullable
    @JsonProperty(value="User")
    public abstract String user();

    @Nullable
    @JsonProperty(value="AttachStdin")
    public abstract Boolean attachStdin();

    @Nullable
    @JsonProperty(value="AttachStdout")
    public abstract Boolean attachStdout();

    @Nullable
    @JsonProperty(value="AttachStderr")
    public abstract Boolean attachStderr();

    @Nullable
    @JsonProperty(value="PortSpecs")
    public abstract ImmutableList<String> portSpecs();

    @Nullable
    @JsonProperty(value="ExposedPorts")
    public abstract ImmutableSet<String> exposedPorts();

    @Nullable
    @JsonProperty(value="Tty")
    public abstract Boolean tty();

    @Nullable
    @JsonProperty(value="OpenStdin")
    public abstract Boolean openStdin();

    @Nullable
    @JsonProperty(value="StdinOnce")
    public abstract Boolean stdinOnce();

    @Nullable
    @JsonProperty(value="Env")
    public abstract ImmutableList<String> env();

    @Nullable
    @JsonProperty(value="Cmd")
    public abstract ImmutableList<String> cmd();

    @Nullable
    @JsonProperty(value="Image")
    public abstract String image();

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH"})
    public Set<String> volumeNames() {
        return this.volumes() == null ? Collections.emptySet() : this.volumes().keySet();
    }

    @Nullable
    @JsonProperty(value="Volumes")
    public abstract ImmutableMap<String, Map> volumes();

    @Nullable
    @JsonProperty(value="WorkingDir")
    public abstract String workingDir();

    @Nullable
    @JsonProperty(value="Entrypoint")
    public abstract ImmutableList<String> entrypoint();

    @Nullable
    @JsonProperty(value="NetworkDisabled")
    public abstract Boolean networkDisabled();

    @Nullable
    @JsonProperty(value="OnBuild")
    public abstract ImmutableList<String> onBuild();

    @Nullable
    @JsonProperty(value="Labels")
    public abstract ImmutableMap<String, String> labels();

    @Nullable
    @JsonProperty(value="MacAddress")
    public abstract String macAddress();

    @Nullable
    @JsonProperty(value="HostConfig")
    public abstract HostConfig hostConfig();

    @Nullable
    @JsonProperty(value="StopSignal")
    public abstract String stopSignal();

    @Deprecated
    public String getStopSignal() {
        return this.stopSignal();
    }

    @JsonCreator
    static ContainerConfig create(@JsonProperty(value="Hostname") String hostname, @JsonProperty(value="Domainname") String domainname, @JsonProperty(value="User") String user, @JsonProperty(value="AttachStdin") Boolean attachStdin, @JsonProperty(value="AttachStdout") Boolean attachStdout, @JsonProperty(value="AttachStderr") Boolean attachStderr, @JsonProperty(value="PortSpecs") List<String> portSpecs, @JsonProperty(value="ExposedPorts") Set<String> exposedPorts, @JsonProperty(value="Tty") Boolean tty, @JsonProperty(value="OpenStdin") Boolean openStdin, @JsonProperty(value="StdinOnce") Boolean stdinOnce, @JsonProperty(value="Env") List<String> env, @JsonProperty(value="Cmd") List<String> cmd, @JsonProperty(value="Image") String image, @JsonProperty(value="Volumes") Map<String, Map> volumes, @JsonProperty(value="WorkingDir") String workingDir, @JsonProperty(value="Entrypoint") List<String> entrypoint, @JsonProperty(value="NetworkDisabled") Boolean networkDisabled, @JsonProperty(value="OnBuild") List<String> onBuild, @JsonProperty(value="Labels") Map<String, String> labels, @JsonProperty(value="MacAddress") String macAddress, @JsonProperty(value="HostConfig") HostConfig hostConfig, @JsonProperty(value="StopSignal") String stopSignal) {
        Builder builder = ContainerConfig.builder().hostname(hostname).domainname(domainname).user(user).attachStdin(attachStdin).attachStdout(attachStdout).attachStderr(attachStderr).tty(tty).openStdin(openStdin).stdinOnce(stdinOnce).image(image).workingDir(workingDir).networkDisabled(networkDisabled).macAddress(macAddress).hostConfig(hostConfig).stopSignal(stopSignal);
        if (portSpecs != null) {
            builder.portSpecs(portSpecs);
        }
        if (exposedPorts != null) {
            builder.exposedPorts(exposedPorts);
        }
        if (env != null) {
            builder.env(env);
        }
        if (cmd != null) {
            builder.cmd(cmd);
        }
        if (volumes != null) {
            builder.volumes(volumes);
        }
        if (entrypoint != null) {
            builder.entrypoint(entrypoint);
        }
        if (onBuild != null) {
            builder.onBuild(onBuild);
        }
        if (labels != null) {
            builder.labels(labels);
        }
        return builder.build();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_ContainerConfig.Builder();
    }

    public static abstract class Builder {
        public abstract Builder hostname(String var1);

        public abstract Builder domainname(String var1);

        public abstract Builder user(String var1);

        public abstract Builder attachStdin(Boolean var1);

        public abstract Builder attachStdout(Boolean var1);

        public abstract Builder attachStderr(Boolean var1);

        public abstract Builder portSpecs(List<String> var1);

        public abstract Builder portSpecs(String ... var1);

        public abstract Builder exposedPorts(Set<String> var1);

        public abstract Builder exposedPorts(String ... var1);

        public abstract Builder tty(Boolean var1);

        public abstract Builder openStdin(Boolean var1);

        public abstract Builder stdinOnce(Boolean var1);

        public abstract Builder env(List<String> var1);

        public abstract Builder env(String ... var1);

        public abstract Builder cmd(List<String> var1);

        public abstract Builder cmd(String ... var1);

        public abstract Builder image(String var1);

        abstract ImmutableMap.Builder<String, Map> volumesBuilder();

        public Builder addVolume(String volume) {
            this.volumesBuilder().put((Object)volume, new HashMap());
            return this;
        }

        public Builder addVolumes(String ... volumes) {
            for (String volume : volumes) {
                this.volumesBuilder().put((Object)volume, new HashMap());
            }
            return this;
        }

        public abstract Builder volumes(Map<String, Map> var1);

        @Deprecated
        public Builder volumes(Set<String> volumes) {
            if (volumes != null && !volumes.isEmpty()) {
                ImmutableMap.Builder volumesBuilder = ImmutableMap.builder();
                for (String volume : volumes) {
                    volumesBuilder.put((Object)volume, new HashMap());
                }
                this.volumes((Map<String, Map>)volumesBuilder.build());
            }
            return this;
        }

        @Deprecated
        public Builder volumes(String ... volumes) {
            if (volumes != null && volumes.length > 0) {
                this.volumes((Set<String>)ImmutableSet.copyOf((Object[])volumes));
            }
            return this;
        }

        public abstract Builder workingDir(String var1);

        public abstract Builder entrypoint(List<String> var1);

        public abstract Builder entrypoint(String ... var1);

        public abstract Builder networkDisabled(Boolean var1);

        public abstract Builder onBuild(List<String> var1);

        public abstract Builder onBuild(String ... var1);

        public abstract Builder labels(Map<String, String> var1);

        public abstract Builder macAddress(String var1);

        public abstract Builder hostConfig(HostConfig var1);

        public abstract Builder stopSignal(String var1);

        public abstract ContainerConfig build();
    }
}

