/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.spotify.docker.client.messages.swarm.AutoValue_Endpoint;
import com.spotify.docker.client.messages.swarm.EndpointSpec;
import com.spotify.docker.client.messages.swarm.EndpointVirtualIp;
import com.spotify.docker.client.messages.swarm.PortConfig;
import java.util.List;
import javax.annotation.Nullable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public abstract class Endpoint {
    @JsonProperty(value="Spec")
    public abstract EndpointSpec spec();

    @Nullable
    @JsonProperty(value="ExposedPorts")
    public abstract ImmutableList<PortConfig> exposedPorts();

    @Nullable
    @JsonProperty(value="VirtualIPs")
    public abstract ImmutableList<EndpointVirtualIp> virtualIps();

    @JsonCreator
    static Endpoint create(@JsonProperty(value="Spec") EndpointSpec spec, @JsonProperty(value="ExposedPorts") List<PortConfig> exposedPorts, @JsonProperty(value="VirtualIPs") List<EndpointVirtualIp> virtualIps) {
        ImmutableList exposedPortsT = exposedPorts == null ? null : ImmutableList.copyOf(exposedPorts);
        ImmutableList virtualIpsT = virtualIps == null ? null : ImmutableList.copyOf(virtualIps);
        return new AutoValue_Endpoint(spec, (ImmutableList<PortConfig>)exposedPortsT, (ImmutableList<EndpointVirtualIp>)virtualIpsT);
    }
}

