/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.spotify.docker.client.messages.Device;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.LogConfig;
import com.spotify.docker.client.messages.PortBinding;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

final class AutoValue_HostConfig
extends HostConfig {
    private final ImmutableList<String> binds;
    private final Integer blkioWeight;
    private final ImmutableList<HostConfig.BlkioWeightDevice> blkioWeightDevice;
    private final ImmutableList<HostConfig.BlkioDeviceRate> blkioDeviceReadBps;
    private final ImmutableList<HostConfig.BlkioDeviceRate> blkioDeviceWriteBps;
    private final ImmutableList<HostConfig.BlkioDeviceRate> blkioDeviceReadIOps;
    private final ImmutableList<HostConfig.BlkioDeviceRate> blkioDeviceWriteIOps;
    private final String containerIdFile;
    private final ImmutableList<HostConfig.LxcConfParameter> lxcConf;
    private final Boolean privileged;
    private final ImmutableMap<String, List<PortBinding>> portBindings;
    private final ImmutableList<String> links;
    private final Boolean publishAllPorts;
    private final ImmutableList<String> dns;
    private final ImmutableList<String> dnsOptions;
    private final ImmutableList<String> dnsSearch;
    private final ImmutableList<String> extraHosts;
    private final ImmutableList<String> volumesFrom;
    private final ImmutableList<String> capAdd;
    private final ImmutableList<String> capDrop;
    private final String networkMode;
    private final ImmutableList<String> securityOpt;
    private final ImmutableList<Device> devices;
    private final Long memory;
    private final Long memorySwap;
    private final Integer memorySwappiness;
    private final Long memoryReservation;
    private final Long cpuPeriod;
    private final Long cpuShares;
    private final String cpusetCpus;
    private final String cpusetMems;
    private final Long cpuQuota;
    private final String cgroupParent;
    private final HostConfig.RestartPolicy restartPolicy;
    private final LogConfig logConfig;
    private final String ipcMode;
    private final ImmutableList<HostConfig.Ulimit> ulimits;
    private final String pidMode;
    private final Long shmSize;
    private final Boolean oomKillDisable;
    private final Integer oomScoreAdj;
    private final Boolean autoRemove;
    private final Integer pidsLimit;
    private final ImmutableMap<String, String> tmpfs;
    private final Boolean readonlyRootfs;

    private AutoValue_HostConfig(@Nullable ImmutableList<String> binds, @Nullable Integer blkioWeight, @Nullable ImmutableList<HostConfig.BlkioWeightDevice> blkioWeightDevice, @Nullable ImmutableList<HostConfig.BlkioDeviceRate> blkioDeviceReadBps, @Nullable ImmutableList<HostConfig.BlkioDeviceRate> blkioDeviceWriteBps, @Nullable ImmutableList<HostConfig.BlkioDeviceRate> blkioDeviceReadIOps, @Nullable ImmutableList<HostConfig.BlkioDeviceRate> blkioDeviceWriteIOps, @Nullable String containerIdFile, @Nullable ImmutableList<HostConfig.LxcConfParameter> lxcConf, @Nullable Boolean privileged, @Nullable ImmutableMap<String, List<PortBinding>> portBindings, @Nullable ImmutableList<String> links, @Nullable Boolean publishAllPorts, @Nullable ImmutableList<String> dns, @Nullable ImmutableList<String> dnsOptions, @Nullable ImmutableList<String> dnsSearch, @Nullable ImmutableList<String> extraHosts, @Nullable ImmutableList<String> volumesFrom, @Nullable ImmutableList<String> capAdd, @Nullable ImmutableList<String> capDrop, @Nullable String networkMode, @Nullable ImmutableList<String> securityOpt, @Nullable ImmutableList<Device> devices, @Nullable Long memory, @Nullable Long memorySwap, @Nullable Integer memorySwappiness, @Nullable Long memoryReservation, @Nullable Long cpuPeriod, @Nullable Long cpuShares, @Nullable String cpusetCpus, @Nullable String cpusetMems, @Nullable Long cpuQuota, @Nullable String cgroupParent, @Nullable HostConfig.RestartPolicy restartPolicy, @Nullable LogConfig logConfig, @Nullable String ipcMode, @Nullable ImmutableList<HostConfig.Ulimit> ulimits, @Nullable String pidMode, @Nullable Long shmSize, @Nullable Boolean oomKillDisable, @Nullable Integer oomScoreAdj, @Nullable Boolean autoRemove, @Nullable Integer pidsLimit, @Nullable ImmutableMap<String, String> tmpfs, @Nullable Boolean readonlyRootfs) {
        this.binds = binds;
        this.blkioWeight = blkioWeight;
        this.blkioWeightDevice = blkioWeightDevice;
        this.blkioDeviceReadBps = blkioDeviceReadBps;
        this.blkioDeviceWriteBps = blkioDeviceWriteBps;
        this.blkioDeviceReadIOps = blkioDeviceReadIOps;
        this.blkioDeviceWriteIOps = blkioDeviceWriteIOps;
        this.containerIdFile = containerIdFile;
        this.lxcConf = lxcConf;
        this.privileged = privileged;
        this.portBindings = portBindings;
        this.links = links;
        this.publishAllPorts = publishAllPorts;
        this.dns = dns;
        this.dnsOptions = dnsOptions;
        this.dnsSearch = dnsSearch;
        this.extraHosts = extraHosts;
        this.volumesFrom = volumesFrom;
        this.capAdd = capAdd;
        this.capDrop = capDrop;
        this.networkMode = networkMode;
        this.securityOpt = securityOpt;
        this.devices = devices;
        this.memory = memory;
        this.memorySwap = memorySwap;
        this.memorySwappiness = memorySwappiness;
        this.memoryReservation = memoryReservation;
        this.cpuPeriod = cpuPeriod;
        this.cpuShares = cpuShares;
        this.cpusetCpus = cpusetCpus;
        this.cpusetMems = cpusetMems;
        this.cpuQuota = cpuQuota;
        this.cgroupParent = cgroupParent;
        this.restartPolicy = restartPolicy;
        this.logConfig = logConfig;
        this.ipcMode = ipcMode;
        this.ulimits = ulimits;
        this.pidMode = pidMode;
        this.shmSize = shmSize;
        this.oomKillDisable = oomKillDisable;
        this.oomScoreAdj = oomScoreAdj;
        this.autoRemove = autoRemove;
        this.pidsLimit = pidsLimit;
        this.tmpfs = tmpfs;
        this.readonlyRootfs = readonlyRootfs;
    }

    @Override
    @Nullable
    @JsonProperty(value="Binds")
    public ImmutableList<String> binds() {
        return this.binds;
    }

    @Override
    @Nullable
    @JsonProperty(value="BlkioWeight")
    public Integer blkioWeight() {
        return this.blkioWeight;
    }

    @Override
    @Nullable
    @JsonProperty(value="BlkioWeightDevice")
    public ImmutableList<HostConfig.BlkioWeightDevice> blkioWeightDevice() {
        return this.blkioWeightDevice;
    }

    @Override
    @Nullable
    @JsonProperty(value="BlkioDeviceReadBps")
    public ImmutableList<HostConfig.BlkioDeviceRate> blkioDeviceReadBps() {
        return this.blkioDeviceReadBps;
    }

    @Override
    @Nullable
    @JsonProperty(value="BlkioDeviceWriteBps")
    public ImmutableList<HostConfig.BlkioDeviceRate> blkioDeviceWriteBps() {
        return this.blkioDeviceWriteBps;
    }

    @Override
    @Nullable
    @JsonProperty(value="BlkioDeviceReadIOps")
    public ImmutableList<HostConfig.BlkioDeviceRate> blkioDeviceReadIOps() {
        return this.blkioDeviceReadIOps;
    }

    @Override
    @Nullable
    @JsonProperty(value="BlkioDeviceWriteIOps")
    public ImmutableList<HostConfig.BlkioDeviceRate> blkioDeviceWriteIOps() {
        return this.blkioDeviceWriteIOps;
    }

    @Override
    @Nullable
    @JsonProperty(value="ContainerIDFile")
    public String containerIdFile() {
        return this.containerIdFile;
    }

    @Override
    @Nullable
    @JsonProperty(value="LxcConf")
    public ImmutableList<HostConfig.LxcConfParameter> lxcConf() {
        return this.lxcConf;
    }

    @Override
    @Nullable
    @JsonProperty(value="Privileged")
    public Boolean privileged() {
        return this.privileged;
    }

    @Override
    @Nullable
    @JsonProperty(value="PortBindings")
    public ImmutableMap<String, List<PortBinding>> portBindings() {
        return this.portBindings;
    }

    @Override
    @Nullable
    @JsonProperty(value="Links")
    public ImmutableList<String> links() {
        return this.links;
    }

    @Override
    @Nullable
    @JsonProperty(value="PublishAllPorts")
    public Boolean publishAllPorts() {
        return this.publishAllPorts;
    }

    @Override
    @Nullable
    @JsonProperty(value="Dns")
    public ImmutableList<String> dns() {
        return this.dns;
    }

    @Override
    @Nullable
    @JsonProperty(value="DnsOptions")
    public ImmutableList<String> dnsOptions() {
        return this.dnsOptions;
    }

    @Override
    @Nullable
    @JsonProperty(value="DnsSearch")
    public ImmutableList<String> dnsSearch() {
        return this.dnsSearch;
    }

    @Override
    @Nullable
    @JsonProperty(value="ExtraHosts")
    public ImmutableList<String> extraHosts() {
        return this.extraHosts;
    }

    @Override
    @Nullable
    @JsonProperty(value="VolumesFrom")
    public ImmutableList<String> volumesFrom() {
        return this.volumesFrom;
    }

    @Override
    @Nullable
    @JsonProperty(value="CapAdd")
    public ImmutableList<String> capAdd() {
        return this.capAdd;
    }

    @Override
    @Nullable
    @JsonProperty(value="CapDrop")
    public ImmutableList<String> capDrop() {
        return this.capDrop;
    }

    @Override
    @Nullable
    @JsonProperty(value="NetworkMode")
    public String networkMode() {
        return this.networkMode;
    }

    @Override
    @Nullable
    @JsonProperty(value="SecurityOpt")
    public ImmutableList<String> securityOpt() {
        return this.securityOpt;
    }

    @Override
    @Nullable
    @JsonProperty(value="Devices")
    public ImmutableList<Device> devices() {
        return this.devices;
    }

    @Override
    @Nullable
    @JsonProperty(value="Memory")
    public Long memory() {
        return this.memory;
    }

    @Override
    @Nullable
    @JsonProperty(value="MemorySwap")
    public Long memorySwap() {
        return this.memorySwap;
    }

    @Override
    @Nullable
    @JsonProperty(value="MemorySwappiness")
    public Integer memorySwappiness() {
        return this.memorySwappiness;
    }

    @Override
    @Nullable
    @JsonProperty(value="MemoryReservation")
    public Long memoryReservation() {
        return this.memoryReservation;
    }

    @Override
    @Nullable
    @JsonProperty(value="CpuPeriod")
    public Long cpuPeriod() {
        return this.cpuPeriod;
    }

    @Override
    @Nullable
    @JsonProperty(value="CpuShares")
    public Long cpuShares() {
        return this.cpuShares;
    }

    @Override
    @Nullable
    @JsonProperty(value="CpusetCpus")
    public String cpusetCpus() {
        return this.cpusetCpus;
    }

    @Override
    @Nullable
    @JsonProperty(value="CpusetMems")
    public String cpusetMems() {
        return this.cpusetMems;
    }

    @Override
    @Nullable
    @JsonProperty(value="CpuQuota")
    public Long cpuQuota() {
        return this.cpuQuota;
    }

    @Override
    @Nullable
    @JsonProperty(value="CgroupParent")
    public String cgroupParent() {
        return this.cgroupParent;
    }

    @Override
    @Nullable
    @JsonProperty(value="RestartPolicy")
    public HostConfig.RestartPolicy restartPolicy() {
        return this.restartPolicy;
    }

    @Override
    @Nullable
    @JsonProperty(value="LogConfig")
    public LogConfig logConfig() {
        return this.logConfig;
    }

    @Override
    @Nullable
    @JsonProperty(value="IpcMode")
    public String ipcMode() {
        return this.ipcMode;
    }

    @Override
    @Nullable
    @JsonProperty(value="Ulimits")
    public ImmutableList<HostConfig.Ulimit> ulimits() {
        return this.ulimits;
    }

    @Override
    @Nullable
    @JsonProperty(value="PidMode")
    public String pidMode() {
        return this.pidMode;
    }

    @Override
    @Nullable
    @JsonProperty(value="ShmSize")
    public Long shmSize() {
        return this.shmSize;
    }

    @Override
    @Nullable
    @JsonProperty(value="OomKillDisable")
    public Boolean oomKillDisable() {
        return this.oomKillDisable;
    }

    @Override
    @Nullable
    @JsonProperty(value="OomScoreAdj")
    public Integer oomScoreAdj() {
        return this.oomScoreAdj;
    }

    @Override
    @Nullable
    @JsonProperty(value="AutoRemove")
    public Boolean autoRemove() {
        return this.autoRemove;
    }

    @Override
    @Nullable
    @JsonProperty(value="PidsLimit")
    public Integer pidsLimit() {
        return this.pidsLimit;
    }

    @Override
    @Nullable
    @JsonProperty(value="Tmpfs")
    public ImmutableMap<String, String> tmpfs() {
        return this.tmpfs;
    }

    @Override
    @Nullable
    @JsonProperty(value="ReadonlyRootfs")
    public Boolean readonlyRootfs() {
        return this.readonlyRootfs;
    }

    public String toString() {
        return "HostConfig{binds=" + this.binds + ", " + "blkioWeight=" + this.blkioWeight + ", " + "blkioWeightDevice=" + this.blkioWeightDevice + ", " + "blkioDeviceReadBps=" + this.blkioDeviceReadBps + ", " + "blkioDeviceWriteBps=" + this.blkioDeviceWriteBps + ", " + "blkioDeviceReadIOps=" + this.blkioDeviceReadIOps + ", " + "blkioDeviceWriteIOps=" + this.blkioDeviceWriteIOps + ", " + "containerIdFile=" + this.containerIdFile + ", " + "lxcConf=" + this.lxcConf + ", " + "privileged=" + this.privileged + ", " + "portBindings=" + this.portBindings + ", " + "links=" + this.links + ", " + "publishAllPorts=" + this.publishAllPorts + ", " + "dns=" + this.dns + ", " + "dnsOptions=" + this.dnsOptions + ", " + "dnsSearch=" + this.dnsSearch + ", " + "extraHosts=" + this.extraHosts + ", " + "volumesFrom=" + this.volumesFrom + ", " + "capAdd=" + this.capAdd + ", " + "capDrop=" + this.capDrop + ", " + "networkMode=" + this.networkMode + ", " + "securityOpt=" + this.securityOpt + ", " + "devices=" + this.devices + ", " + "memory=" + this.memory + ", " + "memorySwap=" + this.memorySwap + ", " + "memorySwappiness=" + this.memorySwappiness + ", " + "memoryReservation=" + this.memoryReservation + ", " + "cpuPeriod=" + this.cpuPeriod + ", " + "cpuShares=" + this.cpuShares + ", " + "cpusetCpus=" + this.cpusetCpus + ", " + "cpusetMems=" + this.cpusetMems + ", " + "cpuQuota=" + this.cpuQuota + ", " + "cgroupParent=" + this.cgroupParent + ", " + "restartPolicy=" + this.restartPolicy + ", " + "logConfig=" + this.logConfig + ", " + "ipcMode=" + this.ipcMode + ", " + "ulimits=" + this.ulimits + ", " + "pidMode=" + this.pidMode + ", " + "shmSize=" + this.shmSize + ", " + "oomKillDisable=" + this.oomKillDisable + ", " + "oomScoreAdj=" + this.oomScoreAdj + ", " + "autoRemove=" + this.autoRemove + ", " + "pidsLimit=" + this.pidsLimit + ", " + "tmpfs=" + this.tmpfs + ", " + "readonlyRootfs=" + this.readonlyRootfs + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HostConfig) {
            HostConfig that = (HostConfig)o;
            return (this.binds == null ? that.binds() == null : this.binds.equals(that.binds())) && (this.blkioWeight == null ? that.blkioWeight() == null : this.blkioWeight.equals(that.blkioWeight())) && (this.blkioWeightDevice == null ? that.blkioWeightDevice() == null : this.blkioWeightDevice.equals(that.blkioWeightDevice())) && (this.blkioDeviceReadBps == null ? that.blkioDeviceReadBps() == null : this.blkioDeviceReadBps.equals(that.blkioDeviceReadBps())) && (this.blkioDeviceWriteBps == null ? that.blkioDeviceWriteBps() == null : this.blkioDeviceWriteBps.equals(that.blkioDeviceWriteBps())) && (this.blkioDeviceReadIOps == null ? that.blkioDeviceReadIOps() == null : this.blkioDeviceReadIOps.equals(that.blkioDeviceReadIOps())) && (this.blkioDeviceWriteIOps == null ? that.blkioDeviceWriteIOps() == null : this.blkioDeviceWriteIOps.equals(that.blkioDeviceWriteIOps())) && (this.containerIdFile == null ? that.containerIdFile() == null : this.containerIdFile.equals(that.containerIdFile())) && (this.lxcConf == null ? that.lxcConf() == null : this.lxcConf.equals(that.lxcConf())) && (this.privileged == null ? that.privileged() == null : this.privileged.equals(that.privileged())) && (this.portBindings == null ? that.portBindings() == null : this.portBindings.equals(that.portBindings())) && (this.links == null ? that.links() == null : this.links.equals(that.links())) && (this.publishAllPorts == null ? that.publishAllPorts() == null : this.publishAllPorts.equals(that.publishAllPorts())) && (this.dns == null ? that.dns() == null : this.dns.equals(that.dns())) && (this.dnsOptions == null ? that.dnsOptions() == null : this.dnsOptions.equals(that.dnsOptions())) && (this.dnsSearch == null ? that.dnsSearch() == null : this.dnsSearch.equals(that.dnsSearch())) && (this.extraHosts == null ? that.extraHosts() == null : this.extraHosts.equals(that.extraHosts())) && (this.volumesFrom == null ? that.volumesFrom() == null : this.volumesFrom.equals(that.volumesFrom())) && (this.capAdd == null ? that.capAdd() == null : this.capAdd.equals(that.capAdd())) && (this.capDrop == null ? that.capDrop() == null : this.capDrop.equals(that.capDrop())) && (this.networkMode == null ? that.networkMode() == null : this.networkMode.equals(that.networkMode())) && (this.securityOpt == null ? that.securityOpt() == null : this.securityOpt.equals(that.securityOpt())) && (this.devices == null ? that.devices() == null : this.devices.equals(that.devices())) && (this.memory == null ? that.memory() == null : this.memory.equals(that.memory())) && (this.memorySwap == null ? that.memorySwap() == null : this.memorySwap.equals(that.memorySwap())) && (this.memorySwappiness == null ? that.memorySwappiness() == null : this.memorySwappiness.equals(that.memorySwappiness())) && (this.memoryReservation == null ? that.memoryReservation() == null : this.memoryReservation.equals(that.memoryReservation())) && (this.cpuPeriod == null ? that.cpuPeriod() == null : this.cpuPeriod.equals(that.cpuPeriod())) && (this.cpuShares == null ? that.cpuShares() == null : this.cpuShares.equals(that.cpuShares())) && (this.cpusetCpus == null ? that.cpusetCpus() == null : this.cpusetCpus.equals(that.cpusetCpus())) && (this.cpusetMems == null ? that.cpusetMems() == null : this.cpusetMems.equals(that.cpusetMems())) && (this.cpuQuota == null ? that.cpuQuota() == null : this.cpuQuota.equals(that.cpuQuota())) && (this.cgroupParent == null ? that.cgroupParent() == null : this.cgroupParent.equals(that.cgroupParent())) && (this.restartPolicy == null ? that.restartPolicy() == null : this.restartPolicy.equals(that.restartPolicy())) && (this.logConfig == null ? that.logConfig() == null : this.logConfig.equals(that.logConfig())) && (this.ipcMode == null ? that.ipcMode() == null : this.ipcMode.equals(that.ipcMode())) && (this.ulimits == null ? that.ulimits() == null : this.ulimits.equals(that.ulimits())) && (this.pidMode == null ? that.pidMode() == null : this.pidMode.equals(that.pidMode())) && (this.shmSize == null ? that.shmSize() == null : this.shmSize.equals(that.shmSize())) && (this.oomKillDisable == null ? that.oomKillDisable() == null : this.oomKillDisable.equals(that.oomKillDisable())) && (this.oomScoreAdj == null ? that.oomScoreAdj() == null : this.oomScoreAdj.equals(that.oomScoreAdj())) && (this.autoRemove == null ? that.autoRemove() == null : this.autoRemove.equals(that.autoRemove())) && (this.pidsLimit == null ? that.pidsLimit() == null : this.pidsLimit.equals(that.pidsLimit())) && (this.tmpfs == null ? that.tmpfs() == null : this.tmpfs.equals(that.tmpfs())) && (this.readonlyRootfs == null ? that.readonlyRootfs() == null : this.readonlyRootfs.equals(that.readonlyRootfs()));
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.binds == null ? 0 : this.binds.hashCode();
        h *= 1000003;
        h ^= this.blkioWeight == null ? 0 : this.blkioWeight.hashCode();
        h *= 1000003;
        h ^= this.blkioWeightDevice == null ? 0 : this.blkioWeightDevice.hashCode();
        h *= 1000003;
        h ^= this.blkioDeviceReadBps == null ? 0 : this.blkioDeviceReadBps.hashCode();
        h *= 1000003;
        h ^= this.blkioDeviceWriteBps == null ? 0 : this.blkioDeviceWriteBps.hashCode();
        h *= 1000003;
        h ^= this.blkioDeviceReadIOps == null ? 0 : this.blkioDeviceReadIOps.hashCode();
        h *= 1000003;
        h ^= this.blkioDeviceWriteIOps == null ? 0 : this.blkioDeviceWriteIOps.hashCode();
        h *= 1000003;
        h ^= this.containerIdFile == null ? 0 : this.containerIdFile.hashCode();
        h *= 1000003;
        h ^= this.lxcConf == null ? 0 : this.lxcConf.hashCode();
        h *= 1000003;
        h ^= this.privileged == null ? 0 : this.privileged.hashCode();
        h *= 1000003;
        h ^= this.portBindings == null ? 0 : this.portBindings.hashCode();
        h *= 1000003;
        h ^= this.links == null ? 0 : this.links.hashCode();
        h *= 1000003;
        h ^= this.publishAllPorts == null ? 0 : this.publishAllPorts.hashCode();
        h *= 1000003;
        h ^= this.dns == null ? 0 : this.dns.hashCode();
        h *= 1000003;
        h ^= this.dnsOptions == null ? 0 : this.dnsOptions.hashCode();
        h *= 1000003;
        h ^= this.dnsSearch == null ? 0 : this.dnsSearch.hashCode();
        h *= 1000003;
        h ^= this.extraHosts == null ? 0 : this.extraHosts.hashCode();
        h *= 1000003;
        h ^= this.volumesFrom == null ? 0 : this.volumesFrom.hashCode();
        h *= 1000003;
        h ^= this.capAdd == null ? 0 : this.capAdd.hashCode();
        h *= 1000003;
        h ^= this.capDrop == null ? 0 : this.capDrop.hashCode();
        h *= 1000003;
        h ^= this.networkMode == null ? 0 : this.networkMode.hashCode();
        h *= 1000003;
        h ^= this.securityOpt == null ? 0 : this.securityOpt.hashCode();
        h *= 1000003;
        h ^= this.devices == null ? 0 : this.devices.hashCode();
        h *= 1000003;
        h ^= this.memory == null ? 0 : this.memory.hashCode();
        h *= 1000003;
        h ^= this.memorySwap == null ? 0 : this.memorySwap.hashCode();
        h *= 1000003;
        h ^= this.memorySwappiness == null ? 0 : this.memorySwappiness.hashCode();
        h *= 1000003;
        h ^= this.memoryReservation == null ? 0 : this.memoryReservation.hashCode();
        h *= 1000003;
        h ^= this.cpuPeriod == null ? 0 : this.cpuPeriod.hashCode();
        h *= 1000003;
        h ^= this.cpuShares == null ? 0 : this.cpuShares.hashCode();
        h *= 1000003;
        h ^= this.cpusetCpus == null ? 0 : this.cpusetCpus.hashCode();
        h *= 1000003;
        h ^= this.cpusetMems == null ? 0 : this.cpusetMems.hashCode();
        h *= 1000003;
        h ^= this.cpuQuota == null ? 0 : this.cpuQuota.hashCode();
        h *= 1000003;
        h ^= this.cgroupParent == null ? 0 : this.cgroupParent.hashCode();
        h *= 1000003;
        h ^= this.restartPolicy == null ? 0 : this.restartPolicy.hashCode();
        h *= 1000003;
        h ^= this.logConfig == null ? 0 : this.logConfig.hashCode();
        h *= 1000003;
        h ^= this.ipcMode == null ? 0 : this.ipcMode.hashCode();
        h *= 1000003;
        h ^= this.ulimits == null ? 0 : this.ulimits.hashCode();
        h *= 1000003;
        h ^= this.pidMode == null ? 0 : this.pidMode.hashCode();
        h *= 1000003;
        h ^= this.shmSize == null ? 0 : this.shmSize.hashCode();
        h *= 1000003;
        h ^= this.oomKillDisable == null ? 0 : this.oomKillDisable.hashCode();
        h *= 1000003;
        h ^= this.oomScoreAdj == null ? 0 : this.oomScoreAdj.hashCode();
        h *= 1000003;
        h ^= this.autoRemove == null ? 0 : this.autoRemove.hashCode();
        h *= 1000003;
        h ^= this.pidsLimit == null ? 0 : this.pidsLimit.hashCode();
        h *= 1000003;
        h ^= this.tmpfs == null ? 0 : this.tmpfs.hashCode();
        h *= 1000003;
        return h ^= this.readonlyRootfs == null ? 0 : this.readonlyRootfs.hashCode();
    }

    @Override
    public HostConfig.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends HostConfig.Builder {
        private ImmutableList<String> binds;
        private Integer blkioWeight;
        private ImmutableList<HostConfig.BlkioWeightDevice> blkioWeightDevice;
        private ImmutableList<HostConfig.BlkioDeviceRate> blkioDeviceReadBps;
        private ImmutableList<HostConfig.BlkioDeviceRate> blkioDeviceWriteBps;
        private ImmutableList<HostConfig.BlkioDeviceRate> blkioDeviceReadIOps;
        private ImmutableList<HostConfig.BlkioDeviceRate> blkioDeviceWriteIOps;
        private String containerIdFile;
        private ImmutableList<HostConfig.LxcConfParameter> lxcConf;
        private Boolean privileged;
        private ImmutableMap<String, List<PortBinding>> portBindings;
        private ImmutableList<String> links;
        private Boolean publishAllPorts;
        private ImmutableList<String> dns;
        private ImmutableList<String> dnsOptions;
        private ImmutableList<String> dnsSearch;
        private ImmutableList<String> extraHosts;
        private ImmutableList<String> volumesFrom;
        private ImmutableList<String> capAdd;
        private ImmutableList<String> capDrop;
        private String networkMode;
        private ImmutableList<String> securityOpt;
        private ImmutableList<Device> devices;
        private Long memory;
        private Long memorySwap;
        private Integer memorySwappiness;
        private Long memoryReservation;
        private Long cpuPeriod;
        private Long cpuShares;
        private String cpusetCpus;
        private String cpusetMems;
        private Long cpuQuota;
        private String cgroupParent;
        private HostConfig.RestartPolicy restartPolicy;
        private LogConfig logConfig;
        private String ipcMode;
        private ImmutableList<HostConfig.Ulimit> ulimits;
        private String pidMode;
        private Long shmSize;
        private Boolean oomKillDisable;
        private Integer oomScoreAdj;
        private Boolean autoRemove;
        private Integer pidsLimit;
        private ImmutableMap<String, String> tmpfs;
        private Boolean readonlyRootfs;

        Builder() {
        }

        Builder(HostConfig source) {
            this.binds = source.binds();
            this.blkioWeight = source.blkioWeight();
            this.blkioWeightDevice = source.blkioWeightDevice();
            this.blkioDeviceReadBps = source.blkioDeviceReadBps();
            this.blkioDeviceWriteBps = source.blkioDeviceWriteBps();
            this.blkioDeviceReadIOps = source.blkioDeviceReadIOps();
            this.blkioDeviceWriteIOps = source.blkioDeviceWriteIOps();
            this.containerIdFile = source.containerIdFile();
            this.lxcConf = source.lxcConf();
            this.privileged = source.privileged();
            this.portBindings = source.portBindings();
            this.links = source.links();
            this.publishAllPorts = source.publishAllPorts();
            this.dns = source.dns();
            this.dnsOptions = source.dnsOptions();
            this.dnsSearch = source.dnsSearch();
            this.extraHosts = source.extraHosts();
            this.volumesFrom = source.volumesFrom();
            this.capAdd = source.capAdd();
            this.capDrop = source.capDrop();
            this.networkMode = source.networkMode();
            this.securityOpt = source.securityOpt();
            this.devices = source.devices();
            this.memory = source.memory();
            this.memorySwap = source.memorySwap();
            this.memorySwappiness = source.memorySwappiness();
            this.memoryReservation = source.memoryReservation();
            this.cpuPeriod = source.cpuPeriod();
            this.cpuShares = source.cpuShares();
            this.cpusetCpus = source.cpusetCpus();
            this.cpusetMems = source.cpusetMems();
            this.cpuQuota = source.cpuQuota();
            this.cgroupParent = source.cgroupParent();
            this.restartPolicy = source.restartPolicy();
            this.logConfig = source.logConfig();
            this.ipcMode = source.ipcMode();
            this.ulimits = source.ulimits();
            this.pidMode = source.pidMode();
            this.shmSize = source.shmSize();
            this.oomKillDisable = source.oomKillDisable();
            this.oomScoreAdj = source.oomScoreAdj();
            this.autoRemove = source.autoRemove();
            this.pidsLimit = source.pidsLimit();
            this.tmpfs = source.tmpfs();
            this.readonlyRootfs = source.readonlyRootfs();
        }

        @Override
        public HostConfig.Builder binds(@Nullable List<String> binds) {
            this.binds = binds == null ? null : ImmutableList.copyOf(binds);
            return this;
        }

        @Override
        public HostConfig.Builder binds(String ... binds) {
            this.binds = binds == null ? null : ImmutableList.copyOf((Object[])binds);
            return this;
        }

        @Override
        @Nullable
        public ImmutableList<String> binds() {
            return this.binds;
        }

        @Override
        public HostConfig.Builder blkioWeight(@Nullable Integer blkioWeight) {
            this.blkioWeight = blkioWeight;
            return this;
        }

        @Override
        public HostConfig.Builder blkioWeightDevice(@Nullable List<HostConfig.BlkioWeightDevice> blkioWeightDevice) {
            this.blkioWeightDevice = blkioWeightDevice == null ? null : ImmutableList.copyOf(blkioWeightDevice);
            return this;
        }

        @Override
        public HostConfig.Builder blkioDeviceReadBps(@Nullable List<HostConfig.BlkioDeviceRate> blkioDeviceReadBps) {
            this.blkioDeviceReadBps = blkioDeviceReadBps == null ? null : ImmutableList.copyOf(blkioDeviceReadBps);
            return this;
        }

        @Override
        public HostConfig.Builder blkioDeviceWriteBps(@Nullable List<HostConfig.BlkioDeviceRate> blkioDeviceWriteBps) {
            this.blkioDeviceWriteBps = blkioDeviceWriteBps == null ? null : ImmutableList.copyOf(blkioDeviceWriteBps);
            return this;
        }

        @Override
        public HostConfig.Builder blkioDeviceReadIOps(@Nullable List<HostConfig.BlkioDeviceRate> blkioDeviceReadIOps) {
            this.blkioDeviceReadIOps = blkioDeviceReadIOps == null ? null : ImmutableList.copyOf(blkioDeviceReadIOps);
            return this;
        }

        @Override
        public HostConfig.Builder blkioDeviceWriteIOps(@Nullable List<HostConfig.BlkioDeviceRate> blkioDeviceWriteIOps) {
            this.blkioDeviceWriteIOps = blkioDeviceWriteIOps == null ? null : ImmutableList.copyOf(blkioDeviceWriteIOps);
            return this;
        }

        @Override
        public HostConfig.Builder containerIdFile(@Nullable String containerIdFile) {
            this.containerIdFile = containerIdFile;
            return this;
        }

        @Override
        public HostConfig.Builder lxcConf(@Nullable List<HostConfig.LxcConfParameter> lxcConf) {
            this.lxcConf = lxcConf == null ? null : ImmutableList.copyOf(lxcConf);
            return this;
        }

        @Override
        public HostConfig.Builder lxcConf(HostConfig.LxcConfParameter ... lxcConf) {
            this.lxcConf = lxcConf == null ? null : ImmutableList.copyOf((Object[])lxcConf);
            return this;
        }

        @Override
        public HostConfig.Builder privileged(@Nullable Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        @Override
        public HostConfig.Builder portBindings(@Nullable Map<String, List<PortBinding>> portBindings) {
            this.portBindings = portBindings == null ? null : ImmutableMap.copyOf(portBindings);
            return this;
        }

        @Override
        public HostConfig.Builder links(@Nullable List<String> links) {
            this.links = links == null ? null : ImmutableList.copyOf(links);
            return this;
        }

        @Override
        public HostConfig.Builder links(String ... links) {
            this.links = links == null ? null : ImmutableList.copyOf((Object[])links);
            return this;
        }

        @Override
        public HostConfig.Builder publishAllPorts(@Nullable Boolean publishAllPorts) {
            this.publishAllPorts = publishAllPorts;
            return this;
        }

        @Override
        public HostConfig.Builder dns(@Nullable List<String> dns) {
            this.dns = dns == null ? null : ImmutableList.copyOf(dns);
            return this;
        }

        @Override
        public HostConfig.Builder dns(String ... dns) {
            this.dns = dns == null ? null : ImmutableList.copyOf((Object[])dns);
            return this;
        }

        @Override
        public HostConfig.Builder dnsOptions(@Nullable List<String> dnsOptions) {
            this.dnsOptions = dnsOptions == null ? null : ImmutableList.copyOf(dnsOptions);
            return this;
        }

        @Override
        public HostConfig.Builder dnsOptions(String ... dnsOptions) {
            this.dnsOptions = dnsOptions == null ? null : ImmutableList.copyOf((Object[])dnsOptions);
            return this;
        }

        @Override
        public HostConfig.Builder dnsSearch(@Nullable List<String> dnsSearch) {
            this.dnsSearch = dnsSearch == null ? null : ImmutableList.copyOf(dnsSearch);
            return this;
        }

        @Override
        public HostConfig.Builder dnsSearch(String ... dnsSearch) {
            this.dnsSearch = dnsSearch == null ? null : ImmutableList.copyOf((Object[])dnsSearch);
            return this;
        }

        @Override
        public HostConfig.Builder extraHosts(@Nullable List<String> extraHosts) {
            this.extraHosts = extraHosts == null ? null : ImmutableList.copyOf(extraHosts);
            return this;
        }

        @Override
        public HostConfig.Builder extraHosts(String ... extraHosts) {
            this.extraHosts = extraHosts == null ? null : ImmutableList.copyOf((Object[])extraHosts);
            return this;
        }

        @Override
        public HostConfig.Builder volumesFrom(@Nullable List<String> volumesFrom) {
            this.volumesFrom = volumesFrom == null ? null : ImmutableList.copyOf(volumesFrom);
            return this;
        }

        @Override
        public HostConfig.Builder volumesFrom(String ... volumesFrom) {
            this.volumesFrom = volumesFrom == null ? null : ImmutableList.copyOf((Object[])volumesFrom);
            return this;
        }

        @Override
        public HostConfig.Builder capAdd(@Nullable List<String> capAdd) {
            this.capAdd = capAdd == null ? null : ImmutableList.copyOf(capAdd);
            return this;
        }

        @Override
        public HostConfig.Builder capAdd(String ... capAdd) {
            this.capAdd = capAdd == null ? null : ImmutableList.copyOf((Object[])capAdd);
            return this;
        }

        @Override
        public HostConfig.Builder capDrop(@Nullable List<String> capDrop) {
            this.capDrop = capDrop == null ? null : ImmutableList.copyOf(capDrop);
            return this;
        }

        @Override
        public HostConfig.Builder capDrop(String ... capDrop) {
            this.capDrop = capDrop == null ? null : ImmutableList.copyOf((Object[])capDrop);
            return this;
        }

        @Override
        public HostConfig.Builder networkMode(@Nullable String networkMode) {
            this.networkMode = networkMode;
            return this;
        }

        @Override
        public HostConfig.Builder securityOpt(@Nullable List<String> securityOpt) {
            this.securityOpt = securityOpt == null ? null : ImmutableList.copyOf(securityOpt);
            return this;
        }

        @Override
        public HostConfig.Builder securityOpt(String ... securityOpt) {
            this.securityOpt = securityOpt == null ? null : ImmutableList.copyOf((Object[])securityOpt);
            return this;
        }

        @Override
        public HostConfig.Builder devices(@Nullable List<Device> devices) {
            this.devices = devices == null ? null : ImmutableList.copyOf(devices);
            return this;
        }

        @Override
        public HostConfig.Builder devices(Device ... devices) {
            this.devices = devices == null ? null : ImmutableList.copyOf((Object[])devices);
            return this;
        }

        @Override
        public HostConfig.Builder memory(@Nullable Long memory) {
            this.memory = memory;
            return this;
        }

        @Override
        public HostConfig.Builder memorySwap(@Nullable Long memorySwap) {
            this.memorySwap = memorySwap;
            return this;
        }

        @Override
        public HostConfig.Builder memorySwappiness(@Nullable Integer memorySwappiness) {
            this.memorySwappiness = memorySwappiness;
            return this;
        }

        @Override
        public HostConfig.Builder memoryReservation(@Nullable Long memoryReservation) {
            this.memoryReservation = memoryReservation;
            return this;
        }

        @Override
        public HostConfig.Builder cpuPeriod(@Nullable Long cpuPeriod) {
            this.cpuPeriod = cpuPeriod;
            return this;
        }

        @Override
        public HostConfig.Builder cpuShares(@Nullable Long cpuShares) {
            this.cpuShares = cpuShares;
            return this;
        }

        @Override
        public HostConfig.Builder cpusetCpus(@Nullable String cpusetCpus) {
            this.cpusetCpus = cpusetCpus;
            return this;
        }

        @Override
        public HostConfig.Builder cpusetMems(@Nullable String cpusetMems) {
            this.cpusetMems = cpusetMems;
            return this;
        }

        @Override
        public HostConfig.Builder cpuQuota(@Nullable Long cpuQuota) {
            this.cpuQuota = cpuQuota;
            return this;
        }

        @Override
        public HostConfig.Builder cgroupParent(@Nullable String cgroupParent) {
            this.cgroupParent = cgroupParent;
            return this;
        }

        @Override
        public HostConfig.Builder restartPolicy(@Nullable HostConfig.RestartPolicy restartPolicy) {
            this.restartPolicy = restartPolicy;
            return this;
        }

        @Override
        public HostConfig.Builder logConfig(@Nullable LogConfig logConfig) {
            this.logConfig = logConfig;
            return this;
        }

        @Override
        public HostConfig.Builder ipcMode(@Nullable String ipcMode) {
            this.ipcMode = ipcMode;
            return this;
        }

        @Override
        public HostConfig.Builder ulimits(@Nullable List<HostConfig.Ulimit> ulimits) {
            this.ulimits = ulimits == null ? null : ImmutableList.copyOf(ulimits);
            return this;
        }

        @Override
        public HostConfig.Builder pidMode(@Nullable String pidMode) {
            this.pidMode = pidMode;
            return this;
        }

        @Override
        public HostConfig.Builder shmSize(@Nullable Long shmSize) {
            this.shmSize = shmSize;
            return this;
        }

        @Override
        public HostConfig.Builder oomKillDisable(@Nullable Boolean oomKillDisable) {
            this.oomKillDisable = oomKillDisable;
            return this;
        }

        @Override
        public HostConfig.Builder oomScoreAdj(@Nullable Integer oomScoreAdj) {
            this.oomScoreAdj = oomScoreAdj;
            return this;
        }

        @Override
        public HostConfig.Builder autoRemove(@Nullable Boolean autoRemove) {
            this.autoRemove = autoRemove;
            return this;
        }

        @Override
        public HostConfig.Builder pidsLimit(@Nullable Integer pidsLimit) {
            this.pidsLimit = pidsLimit;
            return this;
        }

        @Override
        public HostConfig.Builder tmpfs(@Nullable Map<String, String> tmpfs) {
            this.tmpfs = tmpfs == null ? null : ImmutableMap.copyOf(tmpfs);
            return this;
        }

        @Override
        public HostConfig.Builder readonlyRootfs(@Nullable Boolean readonlyRootfs) {
            this.readonlyRootfs = readonlyRootfs;
            return this;
        }

        @Override
        public HostConfig build() {
            return new AutoValue_HostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.memorySwappiness, this.memoryReservation, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs);
        }
    }
}

