/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.spotify.docker.client.ObjectMapperProvider;
import com.spotify.docker.client.messages.AutoValue_RegistryAuth;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.glassfish.jersey.internal.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public abstract class RegistryAuth {
    private static final Logger LOG = LoggerFactory.getLogger(RegistryAuth.class);
    private static final String DEFAULT_REGISTRY = "https://index.docker.io/v1/";
    private static final String DUMMY_EMAIL = "1234@5678.com";
    private static final ObjectMapper MAPPER = new ObjectMapperProvider().getContext(RegistryAuth.class);

    @Nullable
    @JsonProperty(value="Username")
    public abstract String username();

    @Nullable
    @JsonProperty(value="Password")
    public abstract String password();

    @Nullable
    @JsonProperty(value="Email")
    public abstract String email();

    @JsonProperty(value="ServerAddress")
    public abstract String serverAddress();

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).add("username", (Object)this.username()).add("serverAddress", (Object)this.serverAddress()).toString();
    }

    public abstract Builder toBuilder();

    public static Builder fromDockerConfig() throws IOException {
        return RegistryAuth.parseDockerConfig(RegistryAuth.defaultConfigPath(), null);
    }

    public static Builder fromDockerConfig(String serverAddress) throws IOException {
        return RegistryAuth.parseDockerConfig(RegistryAuth.defaultConfigPath(), serverAddress);
    }

    @VisibleForTesting
    static Builder fromDockerConfig(Path configPath) throws IOException {
        return RegistryAuth.parseDockerConfig(configPath, null);
    }

    @VisibleForTesting
    static Builder fromDockerConfig(Path configPath, String serverAddress) throws IOException {
        return RegistryAuth.parseDockerConfig(configPath, serverAddress);
    }

    private static Path defaultConfigPath() {
        String home = System.getProperty("user.home");
        Path dockerConfig = Paths.get(home, ".docker", "config.json");
        Path dockerCfg = Paths.get(home, ".dockercfg");
        if (Files.exists(dockerConfig, new LinkOption[0])) {
            LOG.debug("Using configfile: {}", (Object)dockerConfig);
            return dockerConfig;
        }
        if (Files.exists(dockerCfg, new LinkOption[0])) {
            LOG.debug("Using configfile: {} ", (Object)dockerCfg);
            return dockerCfg;
        }
        throw new RuntimeException("Could not find a docker config. Please run 'docker login' to create one");
    }

    private static Builder parseDockerConfig(Path configPath, String serverAddress) throws IOException {
        String[] authParams;
        Preconditions.checkNotNull((Object)configPath);
        Builder authBuilder = RegistryAuth.builder();
        JsonNode authJson = RegistryAuth.extractAuthJson(configPath);
        if (Strings.isNullOrEmpty((String)serverAddress)) {
            Iterator servers = authJson.fieldNames();
            if (servers.hasNext()) {
                serverAddress = (String)servers.next();
            }
        } else if (!authJson.has(serverAddress)) {
            LOG.error("Could not find auth config for {}. Returning empty builder", (Object)serverAddress);
            return RegistryAuth.builder().serverAddress(serverAddress);
        }
        JsonNode serverAuth = authJson.get(serverAddress);
        if (serverAuth != null && serverAuth.has("auth")) {
            authBuilder.serverAddress(serverAddress);
            String authString = serverAuth.get("auth").asText();
            authParams = Base64.decodeAsString((String)authString).split(":");
            if (authParams.length != 2) {
                LOG.warn("Failed to parse auth string for {}", (Object)serverAddress);
                return authBuilder;
            }
        } else {
            LOG.warn("Could not find auth field for {}", (Object)serverAddress);
            return authBuilder;
        }
        authBuilder.username(authParams[0].trim());
        authBuilder.password(authParams[1].trim());
        if (serverAuth.has("email")) {
            authBuilder.email(serverAuth.get("email").asText());
        }
        return authBuilder;
    }

    private static JsonNode extractAuthJson(Path configPath) throws IOException {
        JsonNode config = MAPPER.readTree(configPath.toFile());
        if (config.has("auths")) {
            return config.get("auths");
        }
        return config;
    }

    public static Builder builder() {
        return new AutoValue_RegistryAuth.Builder().serverAddress(DEFAULT_REGISTRY).email(DUMMY_EMAIL);
    }

    public static abstract class Builder {
        public abstract Builder username(String var1);

        public abstract Builder password(String var1);

        public abstract Builder email(String var1);

        public abstract Builder serverAddress(String var1);

        public abstract RegistryAuth build();
    }
}

