/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.spotify.docker.client.messages.AttachedNetwork;
import com.spotify.docker.client.messages.AutoValue_NetworkSettings;
import com.spotify.docker.client.messages.PortBinding;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public abstract class NetworkSettings {
    @Nullable
    @JsonProperty(value="IPAddress")
    public abstract String ipAddress();

    @Nullable
    @JsonProperty(value="IPPrefixLen")
    public abstract Integer ipPrefixLen();

    @Nullable
    @JsonProperty(value="Gateway")
    public abstract String gateway();

    @Nullable
    @JsonProperty(value="Bridge")
    public abstract String bridge();

    @Nullable
    @JsonProperty(value="PortMapping")
    public abstract ImmutableMap<String, Map<String, String>> portMapping();

    @Nullable
    @JsonProperty(value="Ports")
    public abstract ImmutableMap<String, List<PortBinding>> ports();

    @Nullable
    @JsonProperty(value="MacAddress")
    public abstract String macAddress();

    @Nullable
    @JsonProperty(value="Networks")
    public abstract ImmutableMap<String, AttachedNetwork> networks();

    @JsonCreator
    static NetworkSettings create(@JsonProperty(value="IPAddress") String ipAddress, @JsonProperty(value="IPPrefixLen") Integer ipPrefixLen, @JsonProperty(value="Gateway") String gateway, @JsonProperty(value="Bridge") String bridge, @JsonProperty(value="PortMapping") Map<String, Map<String, String>> portMapping, @JsonProperty(value="Ports") Map<String, List<PortBinding>> ports, @JsonProperty(value="MacAddress") String macAddress, @JsonProperty(value="Networks") Map<String, AttachedNetwork> networks) {
        ImmutableMap.Builder portsCopy = ImmutableMap.builder();
        if (ports != null) {
            for (Map.Entry<String, List<PortBinding>> entry : ports.entrySet()) {
                portsCopy.put((Object)entry.getKey(), entry.getValue() == null ? Collections.emptyList() : entry.getValue());
            }
        }
        return NetworkSettings.builder().ipAddress(ipAddress).ipPrefixLen(ipPrefixLen).gateway(gateway).bridge(bridge).portMapping(portMapping).ports((Map<String, List<PortBinding>>)portsCopy.build()).macAddress(macAddress).networks(networks).build();
    }

    public static Builder builder() {
        return new AutoValue_NetworkSettings.Builder();
    }

    public static abstract class Builder {
        public abstract Builder ipAddress(String var1);

        public abstract Builder ipPrefixLen(Integer var1);

        public abstract Builder gateway(String var1);

        public abstract Builder bridge(String var1);

        public abstract Builder portMapping(Map<String, Map<String, String>> var1);

        public abstract Builder ports(Map<String, List<PortBinding>> var1);

        public abstract Builder macAddress(String var1);

        public abstract Builder networks(Map<String, AttachedNetwork> var1);

        public abstract NetworkSettings build();
    }
}

