
package com.spotify.docker.client.messages.mount;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_Mount extends Mount {

  private final String type;
  private final String source;
  private final String target;
  private final Boolean readOnly;
  private final BindOptions bindOptions;
  private final VolumeOptions volumeOptions;

  private AutoValue_Mount(
      String type,
      String source,
      String target,
      @Nullable Boolean readOnly,
      BindOptions bindOptions,
      VolumeOptions volumeOptions) {
    this.type = type;
    this.source = source;
    this.target = target;
    this.readOnly = readOnly;
    this.bindOptions = bindOptions;
    this.volumeOptions = volumeOptions;
  }

  @JsonProperty(value = "Type")
  @Override
  public String type() {
    return type;
  }

  @JsonProperty(value = "Source")
  @Override
  public String source() {
    return source;
  }

  @JsonProperty(value = "Target")
  @Override
  public String target() {
    return target;
  }

  @Nullable
  @JsonProperty(value = "ReadOnly")
  @Override
  public Boolean readOnly() {
    return readOnly;
  }

  @JsonProperty(value = "BindOptions")
  @Override
  public BindOptions bindOptions() {
    return bindOptions;
  }

  @JsonProperty(value = "VolumeOptions")
  @Override
  public VolumeOptions volumeOptions() {
    return volumeOptions;
  }

  @Override
  public String toString() {
    return "Mount{"
        + "type=" + type + ", "
        + "source=" + source + ", "
        + "target=" + target + ", "
        + "readOnly=" + readOnly + ", "
        + "bindOptions=" + bindOptions + ", "
        + "volumeOptions=" + volumeOptions
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Mount) {
      Mount that = (Mount) o;
      return (this.type.equals(that.type()))
           && (this.source.equals(that.source()))
           && (this.target.equals(that.target()))
           && ((this.readOnly == null) ? (that.readOnly() == null) : this.readOnly.equals(that.readOnly()))
           && (this.bindOptions.equals(that.bindOptions()))
           && (this.volumeOptions.equals(that.volumeOptions()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.type.hashCode();
    h *= 1000003;
    h ^= this.source.hashCode();
    h *= 1000003;
    h ^= this.target.hashCode();
    h *= 1000003;
    h ^= (readOnly == null) ? 0 : this.readOnly.hashCode();
    h *= 1000003;
    h ^= this.bindOptions.hashCode();
    h *= 1000003;
    h ^= this.volumeOptions.hashCode();
    return h;
  }

  static final class Builder extends Mount.Builder {
    private String type;
    private String source;
    private String target;
    private Boolean readOnly;
    private BindOptions bindOptions;
    private VolumeOptions volumeOptions;
    Builder() {
    }
    Builder(Mount source) {
      this.type = source.type();
      this.source = source.source();
      this.target = source.target();
      this.readOnly = source.readOnly();
      this.bindOptions = source.bindOptions();
      this.volumeOptions = source.volumeOptions();
    }
    @Override
    public Mount.Builder type(String type) {
      this.type = type;
      return this;
    }
    @Override
    public Mount.Builder source(String source) {
      this.source = source;
      return this;
    }
    @Override
    public Mount.Builder target(String target) {
      this.target = target;
      return this;
    }
    @Override
    public Mount.Builder readOnly(@Nullable Boolean readOnly) {
      this.readOnly = readOnly;
      return this;
    }
    @Override
    public Mount.Builder bindOptions(BindOptions bindOptions) {
      this.bindOptions = bindOptions;
      return this;
    }
    @Override
    public Mount.Builder volumeOptions(VolumeOptions volumeOptions) {
      this.volumeOptions = volumeOptions;
      return this;
    }
    @Override
    public Mount build() {
      String missing = "";
      if (type == null) {
        missing += " type";
      }
      if (source == null) {
        missing += " source";
      }
      if (target == null) {
        missing += " target";
      }
      if (bindOptions == null) {
        missing += " bindOptions";
      }
      if (volumeOptions == null) {
        missing += " volumeOptions";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_Mount(
          this.type,
          this.source,
          this.target,
          this.readOnly,
          this.bindOptions,
          this.volumeOptions);
    }
  }

}
