/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages.mount;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.spotify.docker.client.messages.mount.Driver;
import com.spotify.docker.client.messages.mount.VolumeOptions;
import java.util.Map;
import javax.annotation.Nullable;

final class AutoValue_VolumeOptions
extends VolumeOptions {
    private final Boolean noCopy;
    private final ImmutableMap<String, String> labels;
    private final Driver driverConfig;

    private AutoValue_VolumeOptions(@Nullable Boolean noCopy, ImmutableMap<String, String> labels, Driver driverConfig) {
        this.noCopy = noCopy;
        this.labels = labels;
        this.driverConfig = driverConfig;
    }

    @Override
    @Nullable
    @JsonProperty(value="NoCopy")
    public Boolean noCopy() {
        return this.noCopy;
    }

    @Override
    @JsonProperty(value="Labels")
    public ImmutableMap<String, String> labels() {
        return this.labels;
    }

    @Override
    @JsonProperty(value="DriverConfig")
    public Driver driverConfig() {
        return this.driverConfig;
    }

    public String toString() {
        return "VolumeOptions{noCopy=" + this.noCopy + ", " + "labels=" + this.labels + ", " + "driverConfig=" + this.driverConfig + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof VolumeOptions) {
            VolumeOptions that = (VolumeOptions)o;
            return (this.noCopy == null ? that.noCopy() == null : this.noCopy.equals(that.noCopy())) && this.labels.equals(that.labels()) && this.driverConfig.equals(that.driverConfig());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.noCopy == null ? 0 : this.noCopy.hashCode();
        h *= 1000003;
        h ^= this.labels.hashCode();
        h *= 1000003;
        return h ^= this.driverConfig.hashCode();
    }

    static final class Builder
    extends VolumeOptions.Builder {
        private Boolean noCopy;
        private ImmutableMap.Builder<String, String> labelsBuilder$;
        private ImmutableMap<String, String> labels;
        private Driver driverConfig;

        Builder() {
            this.labels = ImmutableMap.of();
        }

        Builder(VolumeOptions source) {
            this.noCopy = source.noCopy();
            this.labels = source.labels();
            this.driverConfig = source.driverConfig();
        }

        @Override
        public VolumeOptions.Builder noCopy(@Nullable Boolean noCopy) {
            this.noCopy = noCopy;
            return this;
        }

        @Override
        public VolumeOptions.Builder labels(Map<String, String> labels) {
            if (this.labelsBuilder$ != null) {
                throw new IllegalStateException("Cannot set labels after calling labelsBuilder()");
            }
            this.labels = ImmutableMap.copyOf(labels);
            return this;
        }

        @Override
        public ImmutableMap.Builder<String, String> labelsBuilder() {
            if (this.labelsBuilder$ == null) {
                this.labelsBuilder$ = ImmutableMap.builder();
                this.labelsBuilder$.putAll(this.labels);
                this.labels = null;
            }
            return this.labelsBuilder$;
        }

        @Override
        public VolumeOptions.Builder driverConfig(Driver driverConfig) {
            this.driverConfig = driverConfig;
            return this;
        }

        @Override
        public VolumeOptions build() {
            if (this.labelsBuilder$ != null) {
                this.labels = this.labelsBuilder$.build();
            }
            String missing = "";
            if (this.driverConfig == null) {
                missing = missing + " driverConfig";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_VolumeOptions(this.noCopy, this.labels, this.driverConfig);
        }
    }
}

