/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.spotify.docker.client.messages.swarm.AutoValue_ServiceMode;
import com.spotify.docker.client.messages.swarm.GlobalService;
import com.spotify.docker.client.messages.swarm.ReplicatedService;
import javax.annotation.Nullable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public abstract class ServiceMode {
    @JsonProperty(value="Replicated")
    public abstract ReplicatedService replicated();

    @Nullable
    @JsonProperty(value="Global")
    public abstract GlobalService global();

    public static ServiceMode withReplicas(long replicas) {
        return ServiceMode.builder().replicated(ReplicatedService.builder().replicas(replicas).build()).build();
    }

    public static ServiceMode withGlobal() {
        return ServiceMode.builder().global(GlobalService.builder().build()).build();
    }

    public static Builder builder() {
        return new AutoValue_ServiceMode.Builder();
    }

    @JsonCreator
    static ServiceMode create(@JsonProperty(value="Replicated") ReplicatedService replicated, @JsonProperty(value="Global") GlobalService global) {
        return ServiceMode.builder().replicated(replicated).global(global).build();
    }

    public static abstract class Builder {
        public abstract Builder replicated(ReplicatedService var1);

        public abstract Builder global(GlobalService var1);

        public abstract ServiceMode build();
    }
}

