/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.spotify.docker.client.DockerConfigReader;
import com.spotify.docker.client.ObjectMapperProvider;
import com.spotify.docker.client.messages.DockerCredentialHelperAuth;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerCredentialHelper {
    private static final Logger log = LoggerFactory.getLogger(DockerConfigReader.class);
    private static final ObjectMapper mapper = ObjectMapperProvider.objectMapper();
    private static final CredentialHelperDelegate SYSTEM_CREDENTIAL_HELPER_DELEGATE;
    private static CredentialHelperDelegate credentialHelperDelegate;

    @VisibleForTesting
    static void setCredentialHelperDelegate(CredentialHelperDelegate delegate) {
        credentialHelperDelegate = delegate;
    }

    @VisibleForTesting
    static void restoreSystemCredentialHelperDelegate() {
        credentialHelperDelegate = SYSTEM_CREDENTIAL_HELPER_DELEGATE;
    }

    public static int store(String credsStore, DockerCredentialHelperAuth auth) throws IOException, InterruptedException {
        return credentialHelperDelegate.store(credsStore, auth);
    }

    public static int erase(String credsStore, String registry) throws IOException, InterruptedException {
        return credentialHelperDelegate.erase(credsStore, registry);
    }

    public static DockerCredentialHelperAuth get(String credsStore, String registry) throws IOException {
        return credentialHelperDelegate.get(credsStore, registry);
    }

    public static Map<String, String> list(String credsStore) throws IOException {
        return credentialHelperDelegate.list(credsStore);
    }

    static {
        credentialHelperDelegate = SYSTEM_CREDENTIAL_HELPER_DELEGATE = new CredentialHelperDelegate(){

            @Override
            public int store(String credsStore, DockerCredentialHelperAuth auth) throws IOException, InterruptedException {
                Process process = this.exec("store", credsStore);
                try (OutputStreamWriter outStreamWriter = new OutputStreamWriter(process.getOutputStream(), StandardCharsets.UTF_8);
                     BufferedWriter writer = new BufferedWriter(outStreamWriter);){
                    writer.write(mapper.writeValueAsString((Object)auth) + "\n");
                    writer.flush();
                }
                return process.waitFor();
            }

            @Override
            public int erase(String credsStore, String registry) throws IOException, InterruptedException {
                Process process = this.exec("erase", credsStore);
                try (OutputStreamWriter outStreamWriter = new OutputStreamWriter(process.getOutputStream(), StandardCharsets.UTF_8);
                     BufferedWriter writer = new BufferedWriter(outStreamWriter);){
                    writer.write(registry + "\n");
                    writer.flush();
                }
                return process.waitFor();
            }

            /*
             * Exception decompiling
             */
            @Override
            public DockerCredentialHelperAuth get(String credsStore, String registry) throws IOException {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            /*
             * Exception decompiling
             */
            @Override
            public Map<String, String> list(String credsStore) throws IOException {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            private Process exec(String subcommand, String credsStore) throws IOException {
                String cmd = "docker-credential-" + credsStore + " " + subcommand;
                log.debug("Executing \"{}\"", (Object)cmd);
                return Runtime.getRuntime().exec(cmd);
            }
        };
    }

    @VisibleForTesting
    static interface CredentialHelperDelegate {
        public int store(String var1, DockerCredentialHelperAuth var2) throws IOException, InterruptedException;

        public int erase(String var1, String var2) throws IOException, InterruptedException;

        public DockerCredentialHelperAuth get(String var1, String var2) throws IOException;

        public Map<String, String> list(String var1) throws IOException;
    }
}

