/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.spotify.docker.client.messages.AutoValue_RegistryConfigs;
import com.spotify.docker.client.messages.RegistryAuth;
import java.util.Map;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public abstract class RegistryConfigs {
    public static RegistryConfigs empty() {
        return RegistryConfigs.builder().build();
    }

    public abstract ImmutableMap<String, RegistryAuth> configs();

    @JsonCreator
    public static RegistryConfigs create(Map<String, RegistryAuth> configs) {
        if (configs == null) {
            return RegistryConfigs.empty();
        }
        Map transformedMap = Maps.transformEntries(configs, (Maps.EntryTransformer)new Maps.EntryTransformer<String, RegistryAuth, RegistryAuth>(){

            public RegistryAuth transformEntry(String key, RegistryAuth value) {
                if (value == null) {
                    return null;
                }
                if (value.serverAddress() == null) {
                    return value.toBuilder().serverAddress(key).build();
                }
                return value;
            }
        });
        return RegistryConfigs.builder().configs(transformedMap).build();
    }

    public static Builder builder() {
        return new AutoValue_RegistryConfigs.Builder();
    }

    public static abstract class Builder {
        public abstract Builder configs(Map<String, RegistryAuth> var1);

        abstract ImmutableMap.Builder<String, RegistryAuth> configsBuilder();

        public Builder addConfig(String server, RegistryAuth registryAuth) {
            this.configsBuilder().put((Object)server, (Object)registryAuth);
            return this;
        }

        public abstract RegistryConfigs build();
    }
}

