/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.spotify.docker.client.messages.AutoValue_Ipam;
import com.spotify.docker.client.messages.IpamConfig;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.spotify.docker.client.shaded.com.google.common.collect.ImmutableList;
import com.spotify.docker.client.shaded.com.google.common.collect.ImmutableMap;
import com.spotify.docker.client.shaded.javax.annotation.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public abstract class Ipam {
    @JsonProperty(value="Driver")
    public abstract String driver();

    @Nullable
    @JsonProperty(value="Config")
    public abstract ImmutableList<IpamConfig> config();

    @Nullable
    @JsonProperty(value="Options")
    public abstract ImmutableMap<String, String> options();

    public static Builder builder() {
        return new AutoValue_Ipam.Builder();
    }

    public static Ipam create(String driver, List<IpamConfig> config) {
        return Ipam.builder().driver(driver).config(config).options(null).build();
    }

    @JsonCreator
    public static Ipam create(@JsonProperty(value="Driver") String driver, @JsonProperty(value="Config") List<IpamConfig> config, @JsonProperty(value="Options") Map<String, String> options) {
        return Ipam.builder().driver(driver).config(config).options(options).build();
    }

    public static abstract class Builder {
        public abstract Builder driver(String var1);

        public abstract Builder options(Map<String, String> var1);

        public abstract Builder config(List<IpamConfig> var1);

        @Deprecated
        public Builder config(String subnet, String ipRange, String gateway) {
            return Ipam.builder().config(Collections.singletonList(IpamConfig.create(subnet, ipRange, gateway)));
        }

        public abstract Ipam build();
    }
}

