/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.spotify.docker.client.messages.AutoValue_ProgressMessage;
import com.spotify.docker.client.messages.ProgressDetail;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.spotify.docker.client.shaded.javax.annotation.Nullable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public abstract class ProgressMessage {
    private static final String STATUS_DIGEST_PREFIX_16 = "Digest: ";
    private static final String STATUS_DIGEST_PREFIX_18 = "digest: ";
    private static final String STATUS_SIZE_PREFIX_18 = "size: ";

    @Nullable
    @JsonProperty(value="id")
    public abstract String id();

    @Nullable
    @JsonProperty(value="status")
    public abstract String status();

    @Nullable
    @JsonProperty(value="stream")
    public abstract String stream();

    @Nullable
    @JsonProperty(value="error")
    public abstract String error();

    @Nullable
    @JsonProperty(value="progress")
    public abstract String progress();

    @Nullable
    @JsonProperty(value="progressDetail")
    public abstract ProgressDetail progressDetail();

    @JsonCreator
    static ProgressMessage create(@JsonProperty(value="id") String id, @JsonProperty(value="status") String status, @JsonProperty(value="stream") String stream, @JsonProperty(value="error") String error, @JsonProperty(value="progress") String progress, @JsonProperty(value="progressDetail") ProgressDetail progressDetail) {
        return ProgressMessage.builder().id(id).status(status).stream(stream).error(error).progress(progress).progressDetail(progressDetail).build();
    }

    public static Builder builder() {
        return new AutoValue_ProgressMessage.Builder();
    }

    public String buildImageId() {
        String stream = this.stream();
        return stream != null && stream.startsWith("Successfully built") ? stream.substring(stream.lastIndexOf(32) + 1).trim() : null;
    }

    public String digest() {
        String status = this.status();
        if (status == null) {
            return null;
        }
        if (status.startsWith(STATUS_DIGEST_PREFIX_16)) {
            return status.substring(STATUS_DIGEST_PREFIX_16.length()).trim();
        }
        int digestIndex = status.indexOf(STATUS_DIGEST_PREFIX_18);
        int sizeIndex = status.indexOf(STATUS_SIZE_PREFIX_18);
        if (digestIndex > -1 && sizeIndex > digestIndex) {
            int start = digestIndex + STATUS_DIGEST_PREFIX_18.length();
            return status.substring(start, sizeIndex - 1);
        }
        return null;
    }

    public static abstract class Builder {
        public abstract Builder id(String var1);

        public abstract Builder status(String var1);

        public abstract Builder stream(String var1);

        public abstract Builder error(String var1);

        public abstract Builder progress(String var1);

        public abstract Builder progressDetail(ProgressDetail var1);

        public abstract ProgressMessage build();
    }
}

