/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.spotify.docker.client.messages.AutoValue_Network;
import com.spotify.docker.client.messages.AutoValue_Network_Container;
import com.spotify.docker.client.messages.Ipam;
import java.util.Map;
import javax.annotation.Nullable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public abstract class Network {
    @JsonProperty(value="Name")
    public abstract String name();

    @JsonProperty(value="Id")
    public abstract String id();

    @JsonProperty(value="Scope")
    public abstract String scope();

    @JsonProperty(value="Driver")
    public abstract String driver();

    @JsonProperty(value="IPAM")
    public abstract Ipam ipam();

    @Nullable
    @JsonProperty(value="Containers")
    public abstract ImmutableMap<String, Container> containers();

    @JsonProperty(value="Options")
    public abstract ImmutableMap<String, String> options();

    @Nullable
    @JsonProperty(value="Internal")
    public abstract Boolean internal();

    @Nullable
    @JsonProperty(value="EnableIPv6")
    public abstract Boolean enableIPv6();

    @JsonCreator
    static Network create(@JsonProperty(value="Name") String name, @JsonProperty(value="Id") String id, @JsonProperty(value="Scope") String scope, @JsonProperty(value="Driver") String driver, @JsonProperty(value="IPAM") Ipam ipam, @JsonProperty(value="Containers") Map<String, Container> containers, @JsonProperty(value="Options") Map<String, String> options, @JsonProperty(value="Internal") Boolean internal, @JsonProperty(value="EnableIPv6") Boolean enableIPv6) {
        ImmutableMap containersCopy = containers == null ? null : ImmutableMap.copyOf(containers);
        ImmutableMap optionsCopy = options == null ? null : ImmutableMap.copyOf(options);
        return new AutoValue_Network(name, id, scope, driver, ipam, (ImmutableMap<String, Container>)containersCopy, (ImmutableMap<String, String>)optionsCopy, internal, enableIPv6);
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static abstract class Container {
        @JsonProperty(value="EndpointID")
        public abstract String endpointId();

        @JsonProperty(value="MacAddress")
        public abstract String macAddress();

        @JsonProperty(value="IPv4Address")
        public abstract String ipv4Address();

        @JsonProperty(value="IPv6Address")
        public abstract String ipv6Address();

        @JsonCreator
        static Container create(@JsonProperty(value="EndpointID") String endpointId, @JsonProperty(value="MacAddress") String macAddress, @JsonProperty(value="IPv4Address") String ipv4Address, @JsonProperty(value="IPv6Address") String ipv6Address) {
            return new AutoValue_Network_Container(endpointId, macAddress, ipv4Address, ipv6Address);
        }
    }
}

