
package com.spotify.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_NodeSpec extends NodeSpec {

  private final String name;
  private final ImmutableMap<String, String> labels;
  private final String role;
  private final String availability;

  AutoValue_NodeSpec(
      @Nullable String name,
      @Nullable ImmutableMap<String, String> labels,
      String role,
      String availability) {
    this.name = name;
    this.labels = labels;
    if (role == null) {
      throw new NullPointerException("Null role");
    }
    this.role = role;
    if (availability == null) {
      throw new NullPointerException("Null availability");
    }
    this.availability = availability;
  }

  @Nullable
  @JsonProperty(value = "Name")
  @Override
  public String name() {
    return name;
  }

  @Nullable
  @JsonProperty(value = "Labels")
  @Override
  public ImmutableMap<String, String> labels() {
    return labels;
  }

  @JsonProperty(value = "Role")
  @Override
  public String role() {
    return role;
  }

  @JsonProperty(value = "Availability")
  @Override
  public String availability() {
    return availability;
  }

  @Override
  public String toString() {
    return "NodeSpec{"
        + "name=" + name + ", "
        + "labels=" + labels + ", "
        + "role=" + role + ", "
        + "availability=" + availability
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof NodeSpec) {
      NodeSpec that = (NodeSpec) o;
      return ((this.name == null) ? (that.name() == null) : this.name.equals(that.name()))
           && ((this.labels == null) ? (that.labels() == null) : this.labels.equals(that.labels()))
           && (this.role.equals(that.role()))
           && (this.availability.equals(that.availability()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= (name == null) ? 0 : this.name.hashCode();
    h *= 1000003;
    h ^= (labels == null) ? 0 : this.labels.hashCode();
    h *= 1000003;
    h ^= this.role.hashCode();
    h *= 1000003;
    h ^= this.availability.hashCode();
    return h;
  }

}
