/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.auth;

import com.google.common.collect.Lists;
import com.spotify.docker.client.auth.RegistryAuthSupplier;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.messages.RegistryAuth;
import com.spotify.docker.client.messages.RegistryConfigs;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiRegistryAuthSupplier
implements RegistryAuthSupplier {
    private final List<RegistryAuthSupplier> suppliers;

    public MultiRegistryAuthSupplier(List<RegistryAuthSupplier> suppliers) {
        this.suppliers = suppliers;
    }

    @Override
    public RegistryAuth authFor(String imageName) throws DockerException {
        for (RegistryAuthSupplier supplier : this.suppliers) {
            RegistryAuth auth = supplier.authFor(imageName);
            if (auth == null) continue;
            return auth;
        }
        return null;
    }

    @Override
    public RegistryAuth authForSwarm() throws DockerException {
        for (RegistryAuthSupplier supplier : this.suppliers) {
            RegistryAuth auth = supplier.authForSwarm();
            if (auth == null) continue;
            return auth;
        }
        return null;
    }

    @Override
    public RegistryConfigs authForBuild() throws DockerException {
        HashMap<String, RegistryAuth> allConfigs = new HashMap<String, RegistryAuth>();
        for (RegistryAuthSupplier supplier : Lists.reverse(this.suppliers)) {
            RegistryConfigs configs = supplier.authForBuild();
            allConfigs.putAll((Map<String, RegistryAuth>)configs.configs());
        }
        return RegistryConfigs.create(allConfigs);
    }
}

