/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.spotify.docker.client.DockerConfigReader;
import com.spotify.docker.client.messages.AutoValue_RegistryAuth;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.spotify.docker.client.shaded.javax.annotation.Nullable;
import java.io.IOException;
import java.nio.file.Path;
import org.glassfish.jersey.internal.util.Base64;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public abstract class RegistryAuth {
    @Nullable
    @JsonProperty(value="Username")
    public abstract String username();

    @Nullable
    @JsonProperty(value="Password")
    public abstract String password();

    @Nullable
    @JsonProperty(value="Email")
    public abstract String email();

    @Nullable
    @JsonProperty(value="ServerAddress")
    public abstract String serverAddress();

    @Nullable
    @JsonProperty(value="IdentityToken")
    public abstract String identityToken();

    public final String toString() {
        return MoreObjects.toStringHelper(RegistryAuth.class).add("username", (Object)this.username()).add("serverAddress", (Object)this.serverAddress()).add("identityToken", (Object)this.identityToken()).toString();
    }

    public abstract Builder toBuilder();

    @Deprecated
    public static Builder fromDockerConfig() throws IOException {
        DockerConfigReader dockerCfgReader = new DockerConfigReader();
        return dockerCfgReader.fromFirstConfig(dockerCfgReader.defaultConfigPath()).toBuilder();
    }

    public static Builder fromDockerConfig(String serverAddress) throws IOException {
        DockerConfigReader dockerCfgReader = new DockerConfigReader();
        return dockerCfgReader.fromConfig(dockerCfgReader.defaultConfigPath(), serverAddress).toBuilder();
    }

    @VisibleForTesting
    static Builder fromDockerConfig(Path configPath) throws IOException {
        DockerConfigReader dockerCfgReader = new DockerConfigReader();
        return dockerCfgReader.fromConfig(configPath, null).toBuilder();
    }

    @VisibleForTesting
    static Builder fromDockerConfig(Path configPath, String serverAddress) throws IOException {
        DockerConfigReader dockerConfigReader = new DockerConfigReader();
        return dockerConfigReader.fromConfig(configPath, serverAddress).toBuilder();
    }

    @JsonCreator
    public static RegistryAuth create(@JsonProperty(value="username") String username, @JsonProperty(value="password") String password, @JsonProperty(value="email") String email, @JsonProperty(value="serverAddress") String serverAddress, @JsonProperty(value="identityToken") String identityToken, @JsonProperty(value="auth") String auth) {
        Builder builder = auth != null ? RegistryAuth.forAuth(auth) : RegistryAuth.builder().username(username).password(password);
        return builder.email(email).serverAddress(serverAddress).identityToken(identityToken).build();
    }

    public static Builder forAuth(String auth) {
        String[] authParams = Base64.decodeAsString(auth).split(":", 2);
        if (authParams.length != 2) {
            return RegistryAuth.builder();
        }
        return RegistryAuth.builder().username(authParams[0].trim()).password(authParams[1].trim());
    }

    public static Builder builder() {
        return new AutoValue_RegistryAuth.Builder();
    }

    public static abstract class Builder {
        public abstract Builder username(String var1);

        public abstract Builder password(String var1);

        public abstract Builder email(String var1);

        public abstract Builder serverAddress(String var1);

        public abstract Builder identityToken(String var1);

        public abstract RegistryAuth build();
    }
}

