/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.spotify.docker.client.ObjectMapperProvider;
import com.spotify.docker.client.messages.RegistryAuth;
import com.spotify.docker.client.messages.RegistryConfigs;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerConfigReader {
    private static final Logger LOG = LoggerFactory.getLogger(DockerConfigReader.class);
    private static final ObjectMapper MAPPER = ObjectMapperProvider.objectMapper();

    public RegistryConfigs fromConfig(Path configPath) throws IOException {
        return this.parseDockerConfig(configPath);
    }

    public RegistryAuth fromConfig(Path configPath, String serverAddress) throws IOException {
        return this.parseDockerConfig(configPath, serverAddress);
    }

    @Deprecated
    public RegistryAuth fromFirstConfig(Path configPath) throws IOException {
        return this.parseDockerConfig(configPath, null);
    }

    private RegistryAuth parseDockerConfig(Path configPath, String serverAddress) throws IOException {
        Preconditions.checkNotNull((Object)configPath);
        ImmutableMap<String, RegistryAuth> configs = this.parseDockerConfig(configPath).configs();
        if (serverAddress != null && configs.containsKey(serverAddress)) {
            return (RegistryAuth)configs.get(serverAddress);
        }
        if (Strings.isNullOrEmpty((String)serverAddress)) {
            if (configs.isEmpty()) {
                return RegistryAuth.builder().build();
            }
            LOG.warn("Returning first entry from docker config file - use fromConfig(Path) instead, this behavior is deprecated and will soon be removed");
            return (RegistryAuth)configs.values().iterator().next();
        }
        throw new IllegalArgumentException("serverAddress=" + serverAddress + " does not appear in config file at " + configPath);
    }

    private RegistryConfigs parseDockerConfig(Path configPath) throws IOException {
        Preconditions.checkNotNull((Object)configPath);
        return (RegistryConfigs)MAPPER.treeToValue((TreeNode)this.extractAuthJson(configPath), RegistryConfigs.class);
    }

    public Path defaultConfigPath() {
        String home = System.getProperty("user.home");
        Path dockerConfig = Paths.get(home, ".docker", "config.json");
        Path dockerCfg = Paths.get(home, ".dockercfg");
        if (Files.exists(dockerConfig, new LinkOption[0])) {
            LOG.debug("Using configfile: {}", (Object)dockerConfig);
            return dockerConfig;
        }
        LOG.debug("Using configfile: {} ", (Object)dockerCfg);
        return dockerCfg;
    }

    private ObjectNode extractAuthJson(Path configPath) throws IOException {
        File file = configPath.toFile();
        JsonNode config = MAPPER.readTree(file);
        Preconditions.checkState((boolean)config.isObject(), (String)"config file contents are not a JSON Object, instead it is a %s", (Object[])new Object[]{config.getNodeType()});
        if (config.has("auths")) {
            JsonNode auths = config.get("auths");
            Preconditions.checkState((boolean)auths.isObject(), (String)"config file contents are not a JSON Object, instead it is a %s", (Object[])new Object[]{auths.getNodeType()});
            return (ObjectNode)auths;
        }
        return (ObjectNode)config;
    }
}

