/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker;

import com.spotify.docker.client.AnsiProgressHandler;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.DockerException;
import com.spotify.docker.client.ProgressHandler;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

public class Utils {
    public static String[] parseImageName(String imageName) {
        int lastSlashIndex = imageName.lastIndexOf(47);
        int lastColonIndex = imageName.lastIndexOf(58);
        String repo = imageName;
        String tag = null;
        if (lastColonIndex > lastSlashIndex) {
            repo = imageName.substring(0, lastColonIndex);
            tag = imageName.substring(lastColonIndex + 1);
            if (tag.isEmpty()) {
                tag = null;
            }
        }
        return new String[]{repo, tag};
    }

    public static void pushImage(DockerClient docker, String imageName, Log log) throws MojoExecutionException, DockerException, IOException, InterruptedException {
        log.info((CharSequence)("Pushing " + imageName));
        docker.push(imageName, (ProgressHandler)new AnsiProgressHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getGitCommitId() throws GitAPIException, DockerException, IOException, MojoExecutionException {
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        builder.readEnvironment();
        builder.findGitDir();
        if (builder.getGitDir() == null) {
            throw new MojoExecutionException("Cannot tag with git commit ID because directory not a git repo");
        }
        StringBuilder result = new StringBuilder();
        Repository repo = builder.build();
        try {
            Status status;
            ObjectId head = repo.resolve("HEAD");
            result.append(head.getName().substring(0, 7));
            Git git = new Git(repo);
            for (Ref gitTag : git.tagList().call()) {
                if (!gitTag.getObjectId().equals((AnyObjectId)head)) continue;
                String name = gitTag.getName();
                result.append(".");
                result.append(name.substring(name.lastIndexOf(47) + 1));
                break;
            }
            if ((status = git.status().call()).hasUncommittedChanges()) {
                result.append(".DIRTY");
            }
        }
        finally {
            repo.close();
        }
        return result.length() == 0 ? null : result.toString();
    }
}

