/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker;

import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerClient;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;

abstract class AbstractDockerMojo
extends AbstractMojo {
    private static final String DEFAULT_DOCKER_HOST = "tcp://localhost:2375";
    @Component(role=MavenSession.class)
    protected MavenSession session;
    @Component(role=MojoExecution.class)
    protected MojoExecution execution;
    @Parameter(property="dockerHost")
    private String dockerHost;

    AbstractDockerMojo() {
    }

    public void execute() throws MojoExecutionException {
        try {
            this.execute(this.dockerClient());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exception caught", e);
        }
    }

    protected abstract void execute(DockerClient var1) throws Exception;

    protected DockerClient dockerClient() {
        return new DefaultDockerClient(this.dockerHost());
    }

    protected String dockerHost() {
        return this.normalize(this.rawDockerHost());
    }

    private String normalize(String raw) {
        URI normalized;
        String withSchema = raw.contains("://") ? raw : "tcp://" + raw;
        URI uri = URI.create(withSchema);
        try {
            normalized = new URI("http", uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return normalized.toString();
    }

    protected String rawDockerHost() {
        if (this.dockerHost != null) {
            return this.dockerHost;
        }
        String dockerHostEnv = System.getenv("DOCKER_HOST");
        if (dockerHostEnv != null) {
            return dockerHostEnv;
        }
        return DEFAULT_DOCKER_HOST;
    }
}

