/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.spotify.docker.AbstractDockerMojo;
import com.spotify.docker.DockerBuildInformation;
import com.spotify.docker.Git;
import com.spotify.docker.Utils;
import com.spotify.docker.client.AnsiProgressHandler;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.DockerException;
import com.spotify.docker.client.ProgressHandler;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.eclipse.jgit.api.errors.GitAPIException;

@Mojo(name="build")
public class BuildMojo
extends AbstractDockerMojo {
    @Parameter(property="dockerDirectory")
    private String dockerDirectory;
    @Parameter(property="skipDockerBuild", defaultValue="false")
    private boolean skipDockerBuild;
    @Parameter(property="pushImage", defaultValue="false")
    private boolean pushImage;
    @Parameter(property="dockerMaintainer")
    private String maintainer;
    @Parameter(property="dockerBaseImage")
    private String baseImage;
    @Parameter(property="dockerEntryPoint")
    private String entryPoint;
    @Parameter(property="dockerCmd")
    private String cmd;
    @Parameter(property="project.build.directory")
    protected String buildDirectory;
    @Parameter(property="dockerBuildProfile")
    private String profile;
    @Parameter(property="tagInfoFile", defaultValue="${project.build.testOutputDirectory}/image_info.json")
    protected String tagInfoFile;
    @Parameter(property="useGitCommitId", defaultValue="false")
    private boolean useGitCommitId;
    @Parameter(property="dockerResources")
    private List<Resource> resources;
    @Parameter(property="dockerImageName")
    private String imageName;
    @Parameter(property="dockerDefaultBuildProfile")
    private String defaultProfile;
    @Parameter(property="dockerEnv")
    private Map<String, String> env;
    @Parameter(property="dockerExposes")
    private List<String> exposes;
    private Set<String> exposesSet;
    private PluginParameterExpressionEvaluator expressionEvaluator;

    public BuildMojo() {
        this(null);
    }

    public BuildMojo(String defaultProfile) {
        this.defaultProfile = defaultProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute(DockerClient docker) throws MojoExecutionException, GitAPIException, IOException, DockerException, InterruptedException {
        String commitId;
        if (this.skipDockerBuild) {
            this.getLog().info((CharSequence)"Skipping docker build");
            return;
        }
        this.exposesSet = new TreeSet<String>(this.exposes);
        this.expressionEvaluator = new PluginParameterExpressionEvaluator(this.session, this.execution);
        Git git = new Git();
        String string = commitId = git.isRepository() ? git.getCommitId() : null;
        if (commitId == null) {
            this.getLog().debug((CharSequence)"Not a git repository, cannot get commit ID");
        } else {
            this.session.getCurrentProject().getProperties().put("gitShortCommitId", commitId);
            if (this.imageName != null) {
                this.imageName = this.expand(this.imageName);
            }
            if (this.baseImage != null) {
                this.baseImage = this.expand(this.baseImage);
            }
        }
        this.loadProfile();
        this.validateParameters();
        String[] repoTag = Utils.parseImageName(this.imageName);
        String repo = repoTag[0];
        String tag = repoTag[1];
        if (this.useGitCommitId) {
            if (tag != null) {
                this.getLog().warn((CharSequence)"Ignoring useGitCommitId flag because tag is explicitly set in image name ");
            } else {
                if (commitId == null) {
                    throw new MojoExecutionException("Cannot tag with git commit ID because directory not a git repo");
                }
                this.imageName = repo + ":" + commitId;
            }
        }
        this.session.getCurrentProject().getProperties().put("imageName", this.imageName);
        String destination = Paths.get(this.buildDirectory, "docker").toString();
        if (this.dockerDirectory == null) {
            List<String> copiedPaths = this.copyResources(destination);
            this.createDockerFile(destination, copiedPaths);
        } else {
            Resource resource = new Resource();
            resource.setDirectory(this.dockerDirectory);
            this.resources.add(resource);
            this.copyResources(destination);
        }
        this.buildImage(docker, destination);
        Path imageInfoPath = Paths.get(this.tagInfoFile, new String[0]);
        Files.createDirectories(imageInfoPath.getParent(), new FileAttribute[0]);
        FileOutputStream jsonOutput = new FileOutputStream(this.tagInfoFile);
        try {
            jsonOutput.write(new DockerBuildInformation(this.imageName).toJsonBytes());
        }
        finally {
            jsonOutput.close();
        }
        if (this.pushImage) {
            Utils.pushImage(docker, this.imageName, this.getLog());
        }
    }

    private void loadProfile() throws MojoExecutionException {
        Config profileConfig;
        Config profiles;
        Config config = ConfigFactory.load();
        this.defaultProfile = this.get(this.defaultProfile, config, "docker.build.defaultProfile");
        if (this.profile == null) {
            if (this.defaultProfile == null) {
                this.getLog().debug((CharSequence)"Not using any build profile");
                return;
            }
            this.getLog().info((CharSequence)("Using default build profile: " + this.defaultProfile));
            this.profile = this.defaultProfile;
        } else {
            this.getLog().info((CharSequence)("Using build profile: " + this.profile));
        }
        try {
            profiles = config.getConfig("docker.build.profiles");
        }
        catch (ConfigException.Missing e) {
            profiles = ConfigFactory.empty();
        }
        try {
            profileConfig = profiles.getConfig(this.profile);
        }
        catch (ConfigException.Missing e) {
            this.getLog().error((CharSequence)("Docker build profile not found: " + this.profile));
            this.getLog().error((CharSequence)"Docker build profiles available:");
            for (String name : Ordering.natural().sortedCopy((Iterable)profiles.root().keySet())) {
                this.getLog().error((CharSequence)name);
            }
            throw new MojoExecutionException("Docker build profile not found: " + this.profile);
        }
        this.getLog().info((CharSequence)("Build profile: " + this.profile));
        this.getLog().info((CharSequence)profileConfig.root().render(ConfigRenderOptions.concise().setJson(true).setFormatted(true)));
        List resourceConfigs = Collections.emptyList();
        try {
            resourceConfigs = profileConfig.getConfigList("resources");
        }
        catch (ConfigException.Missing ignore) {
            // empty catch block
        }
        for (Config resourceConfig : resourceConfigs) {
            Resource resource = new Resource();
            try {
                resource.setDirectory(this.expand(resourceConfig.getString("directory")));
            }
            catch (ConfigException.Missing e) {
                throw new MojoExecutionException("Invalid resource config, missing directory.", (Exception)((Object)e));
            }
            try {
                resource.setTargetPath(this.expand(resourceConfig.getString("targetPath")));
            }
            catch (ConfigException.Missing ignore) {
                // empty catch block
            }
            try {
                List includes = resourceConfig.getStringList("includes");
                ArrayList expanded = Lists.newArrayList();
                for (String raw : includes) {
                    expanded.add(this.expand(raw));
                }
                resource.setIncludes((List)expanded);
            }
            catch (ConfigException.Missing ignore) {
                // empty catch block
            }
            this.resources.add(resource);
        }
        Config envConfig = ConfigFactory.empty();
        try {
            envConfig = profileConfig.getConfig("env");
        }
        catch (ConfigException.Missing ignore) {
            // empty catch block
        }
        if (this.env == null) {
            this.env = Maps.newHashMap();
        }
        for (Map.Entry entry : envConfig.root().entrySet()) {
            String key = this.expand((String)entry.getKey());
            if (this.env.containsKey(key)) continue;
            this.env.put(key, this.expand(((ConfigValue)entry.getValue()).unwrapped().toString()));
        }
        List exposesList = Collections.emptyList();
        try {
            exposesList = profileConfig.getStringList("exposes");
        }
        catch (ConfigException.Missing ignore) {
            // empty catch block
        }
        for (String raw : exposesList) {
            this.exposesSet.add(this.expand(raw));
        }
        this.imageName = this.get(this.imageName, profileConfig, "imageName");
        this.baseImage = this.get(this.baseImage, profileConfig, "baseImage");
        this.entryPoint = this.get(this.entryPoint, profileConfig, "entryPoint");
        this.cmd = this.get(this.cmd, profileConfig, "cmd");
    }

    private String get(String override, Config config, String path) throws MojoExecutionException {
        if (override != null) {
            return override;
        }
        try {
            return this.expand(config.getString(path));
        }
        catch (ConfigException.Missing e) {
            return null;
        }
    }

    private String expand(String raw) throws MojoExecutionException {
        Object value;
        try {
            value = this.expressionEvaluator.evaluate(raw);
        }
        catch (ExpressionEvaluationException e) {
            throw new MojoExecutionException("Expression evaluation failed: " + raw, (Exception)((Object)e));
        }
        if (value == null) {
            throw new MojoExecutionException("Undefined expression: " + raw);
        }
        return value.toString();
    }

    private void validateParameters() throws MojoExecutionException {
        if (this.dockerDirectory == null) {
            if (this.baseImage == null) {
                throw new MojoExecutionException("Must specify baseImage if dockerDirectory is null");
            }
        } else {
            if (this.baseImage != null) {
                this.getLog().warn((CharSequence)"Ignoring baseImage because dockerDirectory is set");
            }
            if (this.maintainer != null) {
                this.getLog().warn((CharSequence)"Ignoring maintainer because dockerDirectory is set");
            }
            if (this.entryPoint != null) {
                this.getLog().warn((CharSequence)"Ignoring entryPoint because dockerDirectory is set");
            }
            if (this.cmd != null) {
                this.getLog().warn((CharSequence)"Ignoring cmd because dockerDirectory is set");
            }
        }
    }

    private void buildImage(DockerClient docker, String buildDir) throws MojoExecutionException, DockerException, IOException, InterruptedException {
        this.getLog().info((CharSequence)("Building image " + this.imageName));
        docker.build(Paths.get(buildDir, new String[0]), this.imageName, (ProgressHandler)new AnsiProgressHandler(), new DockerClient.BuildParameter[0]);
        this.getLog().info((CharSequence)("Built " + this.imageName));
    }

    private void createDockerFile(String directory, List<String> filesToAdd) throws IOException {
        ArrayList commands = Lists.newArrayList();
        if (this.baseImage != null) {
            commands.add("FROM " + this.baseImage);
        }
        if (this.maintainer != null) {
            commands.add("MAINTAINER " + this.maintainer);
        }
        if (this.entryPoint != null) {
            commands.add("ENTRYPOINT " + this.entryPoint);
        }
        if (this.cmd != null) {
            if (this.entryPoint != null) {
                if (this.cmd.startsWith("[") && this.cmd.endsWith("]")) {
                    commands.add("CMD " + this.cmd);
                } else {
                    ImmutableList args = ImmutableList.copyOf((Iterable)Splitter.on((CharMatcher)CharMatcher.WHITESPACE).omitEmptyStrings().split((CharSequence)this.cmd));
                    StringBuilder cmdBuilder = new StringBuilder("[");
                    for (String arg : args) {
                        cmdBuilder.append('\"').append(arg).append('\"');
                    }
                    cmdBuilder.append(']');
                    String cmdString = cmdBuilder.toString();
                    commands.add("CMD " + cmdString);
                    this.getLog().warn((CharSequence)"Entrypoint provided but cmd is not an explicit list. Attempting to generate CMD string in the form of an argument list.");
                    this.getLog().warn((CharSequence)("CMD " + cmdString));
                }
            } else {
                commands.add("CMD " + this.cmd);
            }
        } else {
            commands.add("CMD []");
        }
        for (String file : filesToAdd) {
            commands.add(String.format("ADD %s %s", file, file));
        }
        if (this.env != null) {
            List sortedKeys = Ordering.natural().sortedCopy(this.env.keySet());
            for (String key : sortedKeys) {
                String value = this.env.get(key);
                commands.add(String.format("ENV %s %s", key, value));
            }
        }
        if (this.exposesSet.size() > 0) {
            commands.add("EXPOSE " + Joiner.on((String)" ").join(this.exposesSet));
        }
        Files.createDirectories(Paths.get(directory, new String[0]), new FileAttribute[0]);
        Files.write(Paths.get(directory, "Dockerfile"), (Iterable<? extends CharSequence>)commands, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private List<String> copyResources(String destination) throws IOException {
        ArrayList allCopiedPaths = Lists.newArrayList();
        for (Resource resource : this.resources) {
            File source = new File(resource.getDirectory());
            List includes = resource.getIncludes();
            List excludes = resource.getExcludes();
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(source);
            scanner.setIncludes(includes.isEmpty() ? null : includes.toArray(new String[includes.size()]));
            scanner.setExcludes(excludes.isEmpty() ? null : excludes.toArray(new String[excludes.size()]));
            scanner.scan();
            String[] includedFiles = scanner.getIncludedFiles();
            if (includedFiles.length == 0) {
                this.getLog().info((CharSequence)"No resources will be copied, no files match specified patterns");
            }
            ArrayList copiedPaths = Lists.newArrayList();
            for (String included : scanner.getIncludedFiles()) {
                Path sourcePath = Paths.get(resource.getDirectory(), included);
                String targetPath = resource.getTargetPath() == null ? "" : resource.getTargetPath();
                Path destPath = Paths.get(destination, targetPath, included);
                this.getLog().info((CharSequence)String.format("Copying %s -> %s", sourcePath, destPath));
                Files.createDirectories(destPath.getParent(), new FileAttribute[0]);
                Files.copy(sourcePath, destPath, StandardCopyOption.REPLACE_EXISTING);
                Path relativePath = Paths.get(targetPath, included);
                copiedPaths.add(relativePath.toString());
            }
            Collections.sort(copiedPaths);
            allCopiedPaths.addAll(copiedPaths);
        }
        return allCopiedPaths;
    }
}

