/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker;

import com.google.common.base.Strings;
import com.spotify.docker.AbstractDockerMojo;
import com.spotify.docker.DockerBuildInformation;
import com.spotify.docker.Git;
import com.spotify.docker.Utils;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.DockerException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.jgit.api.errors.GitAPIException;

@Mojo(name="tag")
public class TagMojo
extends AbstractDockerMojo {
    @Parameter(property="image", required=true)
    private String image;
    @Parameter(property="skipDockerTag", defaultValue="false")
    private boolean skipDockerTag;
    @Parameter(property="newName", required=true)
    private String newName;
    @Parameter(property="pushImage", defaultValue="false")
    private boolean pushImage;
    @Parameter(property="tagInfoFile")
    private String tagInfoFile = "target/image_info.json";
    @Parameter(property="useGitCommitId", defaultValue="false")
    private boolean useGitCommitId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute(DockerClient docker) throws MojoExecutionException, DockerException, IOException, InterruptedException, GitAPIException {
        if (this.skipDockerTag) {
            this.getLog().info((CharSequence)"Skipping docker tag");
            return;
        }
        String[] repoTag = Utils.parseImageName(this.newName);
        String repo = repoTag[0];
        String tag = repoTag[1];
        if (this.useGitCommitId) {
            if (tag != null) {
                this.getLog().warn((CharSequence)"Ignoring useGitCommitId flag because tag is explicitly set in image name ");
            } else {
                tag = new Git().getCommitId();
            }
        }
        String normalizedName = Strings.isNullOrEmpty((String)tag) ? repo : String.format("%s:%s", repo, tag);
        this.getLog().info((CharSequence)String.format("Creating tag %s from %s", normalizedName, this.image));
        docker.tag(this.image, normalizedName);
        try (FileOutputStream jsonOutput = new FileOutputStream(this.tagInfoFile);){
            jsonOutput.write(new DockerBuildInformation(normalizedName, this.getLog()).toJsonBytes());
        }
        if (this.pushImage) {
            Utils.pushImage(docker, this.newName, this.getLog());
        }
    }
}

