/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker;

import com.google.common.base.Strings;
import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.messages.AuthConfig;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.xml.Xpp3Dom;

abstract class AbstractDockerMojo
extends AbstractMojo {
    @Component(role=MavenSession.class)
    protected MavenSession session;
    @Component(role=MojoExecution.class)
    protected MojoExecution execution;
    @Component
    private Settings settings;
    @Parameter(property="dockerHost")
    private String dockerHost;
    @Parameter(property="serverId")
    private String serverId;
    @Parameter(property="registryUrl")
    private String registryUrl;

    AbstractDockerMojo() {
    }

    public void execute() throws MojoExecutionException {
        try (DefaultDockerClient client = null;){
            Server server;
            DefaultDockerClient.Builder builder = DefaultDockerClient.fromEnv().readTimeoutMillis(0L);
            String dockerHost = this.rawDockerHost();
            if (!Strings.isNullOrEmpty((String)dockerHost)) {
                builder.uri(dockerHost);
            }
            if (this.settings != null && (server = this.settings.getServer(this.serverId)) != null) {
                String email;
                String password;
                AuthConfig.Builder authConfigBuilder = AuthConfig.builder();
                String username = server.getUsername();
                if (this.incompleteAuthSettings(username, password = server.getPassword(), email = this.getEmail(server))) {
                    throw new MojoExecutionException("Incomplete Docker registry authorization credentials. Please provide all of username, password, and email or none.");
                }
                if (!Strings.isNullOrEmpty((String)username)) {
                    authConfigBuilder.username(username);
                }
                if (!Strings.isNullOrEmpty((String)email)) {
                    authConfigBuilder.email(email);
                }
                if (!Strings.isNullOrEmpty((String)password)) {
                    authConfigBuilder.password(password);
                }
                if (!Strings.isNullOrEmpty((String)this.registryUrl)) {
                    authConfigBuilder.serverAddress(this.registryUrl);
                }
                builder.authConfig(authConfigBuilder.build());
            }
            client = builder.build();
            this.execute((DockerClient)client);
        }
    }

    protected abstract void execute(DockerClient var1) throws Exception;

    protected String rawDockerHost() {
        return this.dockerHost;
    }

    private String getEmail(Server server) {
        String email = null;
        Xpp3Dom configuration = (Xpp3Dom)server.getConfiguration();
        Xpp3Dom emailNode = configuration.getChild("email");
        if (emailNode != null) {
            email = emailNode.getValue();
        }
        return email;
    }

    private boolean incompleteAuthSettings(String username, String password, String email) {
        return !(Strings.isNullOrEmpty((String)username) && Strings.isNullOrEmpty((String)password) && Strings.isNullOrEmpty((String)email) || !Strings.isNullOrEmpty((String)username) && !Strings.isNullOrEmpty((String)password) && !Strings.isNullOrEmpty((String)email));
    }
}

