/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker;

import com.google.common.base.Strings;
import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerCertificateException;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.messages.AuthConfig;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

abstract class AbstractDockerMojo
extends AbstractMojo {
    @Component(role=MavenSession.class)
    protected MavenSession session;
    @Component(role=MojoExecution.class)
    protected MojoExecution execution;
    @Component
    private Settings settings;
    @Component(role=SecDispatcher.class, hint="mng-4384")
    private SecDispatcher secDispatcher;
    @Parameter(property="dockerHost")
    private String dockerHost;
    @Parameter(property="serverId")
    private String serverId;
    @Parameter(property="registryUrl")
    private String registryUrl;
    @Parameter(property="retryPushCount", defaultValue="5")
    private int retryPushCount;
    @Parameter(property="retryPushTimeout", defaultValue="10000")
    private int retryPushTimeout;

    AbstractDockerMojo() {
    }

    public int getRetryPushTimeout() {
        return this.retryPushTimeout;
    }

    public int getRetryPushCount() {
        return this.retryPushCount;
    }

    public void execute() throws MojoExecutionException {
        try (DefaultDockerClient client = null;){
            AuthConfig authConfig;
            DefaultDockerClient.Builder builder = this.getBuilder();
            String dockerHost = this.rawDockerHost();
            if (!Strings.isNullOrEmpty((String)dockerHost)) {
                builder.uri(dockerHost);
            }
            if ((authConfig = this.authConfig()) != null) {
                builder.authConfig(authConfig);
            }
            client = builder.build();
            this.execute((DockerClient)client);
        }
    }

    protected DefaultDockerClient.Builder getBuilder() throws DockerCertificateException {
        return DefaultDockerClient.fromEnv().readTimeoutMillis(0L);
    }

    protected abstract void execute(DockerClient var1) throws Exception;

    protected String rawDockerHost() {
        return this.dockerHost;
    }

    private String getEmail(Server server) {
        Xpp3Dom emailNode;
        String email = null;
        Xpp3Dom configuration = (Xpp3Dom)server.getConfiguration();
        if (configuration != null && (emailNode = configuration.getChild("email")) != null) {
            email = emailNode.getValue();
        }
        return email;
    }

    private boolean incompleteAuthSettings(String username, String password, String email) {
        return !(Strings.isNullOrEmpty((String)username) && Strings.isNullOrEmpty((String)password) && Strings.isNullOrEmpty((String)email) || !Strings.isNullOrEmpty((String)username) && !Strings.isNullOrEmpty((String)password) && !Strings.isNullOrEmpty((String)email));
    }

    protected AuthConfig authConfig() throws MojoExecutionException, SecDispatcherException {
        Server server;
        if (this.settings != null && (server = this.settings.getServer(this.serverId)) != null) {
            String email;
            AuthConfig.Builder authConfigBuilder = AuthConfig.builder();
            String username = server.getUsername();
            String password = server.getPassword();
            if (this.secDispatcher != null) {
                password = this.secDispatcher.decrypt(password);
            }
            if (this.incompleteAuthSettings(username, password, email = this.getEmail(server))) {
                throw new MojoExecutionException("Incomplete Docker registry authorization credentials. Please provide all of username, password, and email or none.");
            }
            if (!Strings.isNullOrEmpty((String)username)) {
                authConfigBuilder.username(username);
            }
            if (!Strings.isNullOrEmpty((String)email)) {
                authConfigBuilder.email(email);
            }
            if (!Strings.isNullOrEmpty((String)password)) {
                authConfigBuilder.password(password);
            }
            if (!Strings.isNullOrEmpty((String)this.registryUrl)) {
                authConfigBuilder.serverAddress(this.registryUrl);
            }
            return authConfigBuilder.build();
        }
        return null;
    }
}

