/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker;

import com.google.common.base.Strings;
import com.spotify.docker.DockerBuildInformation;
import com.spotify.docker.client.AnsiProgressHandler;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.DockerException;
import com.spotify.docker.client.ProgressHandler;
import com.spotify.docker.client.messages.ProgressMessage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class Utils {
    public static final String PUSH_FAIL_WARN_TEMPLATE = "Failed to push %s, retrying in %d seconds (%d/%d).";

    public static String[] parseImageName(String imageName) throws MojoExecutionException {
        if (Strings.isNullOrEmpty((String)imageName)) {
            throw new MojoExecutionException("You must specify an \"imageName\" in your docker-maven-client's plugin configuration");
        }
        int lastSlashIndex = imageName.lastIndexOf(47);
        int lastColonIndex = imageName.lastIndexOf(58);
        String repo = imageName;
        String tag = null;
        if (lastColonIndex > lastSlashIndex) {
            repo = imageName.substring(0, lastColonIndex);
            tag = imageName.substring(lastColonIndex + 1);
            if (tag.isEmpty()) {
                tag = null;
            }
        }
        return new String[]{repo, tag};
    }

    public static void pushImage(DockerClient docker, String imageName, Log log, DockerBuildInformation buildInfo, int retryPushCount, int retryPushTimeout) throws MojoExecutionException, DockerException, IOException, InterruptedException {
        int attempt = 0;
        do {
            AnsiProgressHandler ansiProgressHandler = new AnsiProgressHandler();
            DigestExtractingProgressHandler handler = new DigestExtractingProgressHandler((ProgressHandler)ansiProgressHandler);
            try {
                log.info((CharSequence)("Pushing " + imageName));
                docker.push(imageName, (ProgressHandler)handler);
            }
            catch (DockerException e) {
                if (attempt < retryPushCount) {
                    log.warn((CharSequence)String.format(PUSH_FAIL_WARN_TEMPLATE, imageName, retryPushTimeout / 1000, attempt + 1, retryPushCount));
                    Thread.sleep(retryPushTimeout);
                    continue;
                }
                throw e;
            }
            if (buildInfo == null) break;
            String imageNameWithoutTag = Utils.parseImageName(imageName)[0];
            buildInfo.setDigest(imageNameWithoutTag + "@" + handler.digest());
            break;
        } while (attempt++ <= retryPushCount);
    }

    public static void writeImageInfoFile(DockerBuildInformation buildInfo, String tagInfoFile) throws IOException {
        Path imageInfoPath = Paths.get(tagInfoFile, new String[0]);
        if (imageInfoPath.getParent() != null) {
            Files.createDirectories(imageInfoPath.getParent(), new FileAttribute[0]);
        }
        Files.write(imageInfoPath, buildInfo.toJsonBytes(), new OpenOption[0]);
    }

    private static class DigestExtractingProgressHandler
    implements ProgressHandler {
        private final ProgressHandler delegate;
        private String digest;

        DigestExtractingProgressHandler(ProgressHandler delegate) {
            this.delegate = delegate;
        }

        public void progress(ProgressMessage message) throws DockerException {
            if (message.digest() != null) {
                this.digest = message.digest();
            }
            this.delegate.progress(message);
        }

        public String digest() {
            return this.digest;
        }
    }
}

