/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;

class CompositeImageName {
    private final List<String> imageTags;
    private final String name;

    private CompositeImageName(String name, List<String> imageTags) {
        this.name = name;
        this.imageTags = imageTags;
    }

    static CompositeImageName create(String imageName, List<String> imageTags) throws MojoExecutionException {
        String name = StringUtils.substringBeforeLast((String)imageName, (String)":");
        if (StringUtils.isBlank((String)name)) {
            throw new MojoExecutionException("imageName not set!");
        }
        ArrayList<String> tags = new ArrayList<String>();
        String tag = StringUtils.substringAfterLast((String)imageName, (String)":");
        if (StringUtils.isNotBlank((String)tag)) {
            tags.add(tag);
        }
        if (imageTags != null) {
            tags.addAll(imageTags);
        }
        if (tags.size() == 0) {
            throw new MojoExecutionException("No tag included in imageName and no imageTags set!");
        }
        return new CompositeImageName(name, tags);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getImageTags() {
        return this.imageTags;
    }
}

